package com.webworxshop.swallowcatcher;

import android.app.ListActivity;
import android.os.Bundle;
import android.view.View;
import android.content.Intent;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ArrayAdapter;
import android.widget.AdapterView.AdapterContextMenuInfo;
import android.view.MenuItem;
import android.view.MenuInflater;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.os.Environment;
import android.os.Bundle;
import android.net.Uri;
import android.util.Log;

import java.util.List;
import java.sql.SQLException;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.io.File;

import com.j256.ormlite.android.apptools.OpenHelperManager;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.stmt.PreparedQuery;

import com.webworxshop.swallowcatcher.db.Episode;
import com.webworxshop.swallowcatcher.db.Subscription;
import com.webworxshop.swallowcatcher.db.DatabaseHelper;
import com.webworxshop.swallowcatcher.downloads.DownloadService;

public class EpisodesListActivity extends ListActivity 
{
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.episodes_list_view);
        
        Intent i = getIntent();
        list_new = i.getBooleanExtra("list_new", false);
        feed_id = i.getIntExtra("feed_id", -1);
    }
    
    @Override
    public void onResume()
    {
    	super.onResume();
    	
		try
		{
			helper = (DatabaseHelper)OpenHelperManager.getHelper(this);
			dao = helper.getEpisodeDao();
			QueryBuilder<Episode, Object> queryBuilder = dao.queryBuilder();
		
			Where where = queryBuilder.where();
			int layout = android.R.layout.simple_list_item_1;
			if(list_new)
			{
				where.eq(Episode.COL_STATUS, "new");
				layout = android.R.layout.simple_list_item_multiple_choice;
				setTitle("New Episodes");
			}
			else
			{
				registerForContextMenu(getListView());
			}
			if(feed_id != -1)
			{
				if(list_new)
				{
					where.and();
				}
				Subscription sub = helper.getSubscriptionDao().queryForId(feed_id);
				where.eq(Episode.COL_SUB, sub);
				setTitle(sub.getName());
			}
			queryBuilder.orderBy(Episode.COL_DATE, false);
		
			preparedQuery = queryBuilder.prepare();
			Log.i("SwallowCatcher", "Query: " + preparedQuery.getStatement());
			episodes = dao.query(preparedQuery);
			
			if(episodes.size() > 0)
			{
				adapter = new ArrayAdapter(this, layout, episodes); 
				setListAdapter(adapter);
			}
		}
		catch(SQLException e)
		{
			Log.e("SwallowCatcher", "Unable to get episodes!", e);
		}
    }
    
    public void markOld(View v)
    {
    	ListView list = (ListView)findViewById(android.R.id.list);
    	
    	for(int i = 0; i < adapter.getCount(); i++)
    	{
    		if(list.isItemChecked(i))
    		{
				Episode ep = episodes.get(i);
				ep.setStatus("old");
				
				try
				{
					dao.update(ep);
					//episodes.remove(ep);
				}
				catch(SQLException e)
				{
					Log.e("SwallowCatcher", "Unable to update episode status!", e);
					return;
				}
    		}
    	}
    	
    	try
    	{
    		episodes = dao.query(preparedQuery);
			int layout = android.R.layout.simple_list_item_multiple_choice;
			adapter = new ArrayAdapter(this, layout, episodes); 
			setListAdapter(adapter);
		}
		catch(SQLException e)
		{
			Log.e("SwallowCatcher", "Unable to update episode list!", e);
		}
    	
    	list.clearChoices();
    	selected_count = 0;
    	findViewById(R.id.bottom_control_bar).setVisibility(View.GONE);
    }
    
    public void download(View v)
    {
    	ListView list = (ListView)findViewById(android.R.id.list);
    	for(int i = 0; i < adapter.getCount(); i++)
    	{
    		if(list.isItemChecked(i))
    		{
				download(i);
			}
		}
    }
    
    public void download(int position)
    {
		Episode ep = episodes.get(position);
		Bundle b = new Bundle();
		b.putSerializable("episode", ep);
			
		Intent in = new Intent(this, DownloadService.class);
		in.putExtras(b);
		getApplicationContext().startService(in);
    }
		
	@Override
    public void onListItemClick(ListView l, View v, int position, long id)
    {
    	if(list_new)
    	{
			if(l.isItemChecked(position))
			{
				l.setItemChecked(position, true);
				selected_count++;
				if(selected_count == 1)
				{
					findViewById(R.id.bottom_control_bar).setVisibility(View.VISIBLE);
				}
			}
			else
			{
				l.setItemChecked(position, false);
				selected_count--;
				if(selected_count == 0)
				{
					findViewById(R.id.bottom_control_bar).setVisibility(View.GONE);
				}
			}
		}
    }
    
    @Override
    protected void onPause()
    {
    	super.onPause();
    	OpenHelperManager.release();
   		helper = null;
    }
    
     @Override
	public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo)
	{
		super.onCreateContextMenu(menu, v, menuInfo);
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.episodes_context_menu, menu);
		
		AdapterContextMenuInfo info = (AdapterContextMenuInfo)menuInfo;
		Episode e = episodes.get((int)info.id);
		menu.findItem(R.id.play_episode).setEnabled(e.getStatus().equals("downloaded"));
		menu.findItem(R.id.download_episode).setEnabled(!e.getStatus().equals("downloaded"));
	}
	
	@Override
	public boolean onContextItemSelected(MenuItem item)
	{
		AdapterContextMenuInfo info = (AdapterContextMenuInfo) item.getMenuInfo();
		switch (item.getItemId())
		{
			case R.id.download_episode:
				download((int)info.id);
				return true;
			case R.id.share_episode:
				shareEpisode(info.id);
				return true;
			case R.id.play_episode:
				playEpisode(info.id);
				return true;
			default:
				return super.onContextItemSelected(item);
		}
	}
	
	public void shareEpisode(long id)
	{
		Episode e = episodes.get((int)id);
		Intent i = new Intent(Intent.ACTION_SEND);
		i.setType("text/plain");
		i.putExtra(Intent.EXTRA_TEXT, "Sharing: " + e.getTitle() + " " + e.getLink());
		startActivity(i);
	}
	
	public void playEpisode(long id)
	{
		try
		{
			Episode e = episodes.get((int)id);
		
			// a lot of this code is copied from other places for now
			// TODO: perhaps there is a better way to do this?
			String url = e.getFileLink();
			String[] toks = url.split("/");
		
			Subscription sub = e.getSubscription();
			Dao<Subscription, Object> sub_dao = helper.getSubscriptionDao();
			sub_dao.refresh(sub);
			String path = sub.getName() + "/" + toks[toks.length - 1];
		
			Pattern p = Pattern.compile("[?><\\:*|^]");
			Matcher m = p.matcher(path);
			path = m.replaceAll("_");
		
			File dir = Environment.getExternalStorageDirectory(); 
			File file = new File(dir, "Podcasts/" + path);
		
			Intent i = new Intent(Intent.ACTION_VIEW);
			i.setDataAndType(Uri.parse("file://" + file.toString()), "audio/*");
			startActivity(i);
		}
		catch(SQLException ex)
		{
			// TODO: really need to handle these better
			Log.e("SwallowCatcher", "Can't play episode!", ex);
		}
	}
    
    private DatabaseHelper helper = null;
    private Dao<Episode, Object> dao = null;
    private List<Episode> episodes = null;
    private ArrayAdapter<Episode> adapter = null;
    private boolean list_new = false;
    private int feed_id;
    private int selected_count = 0;
    private PreparedQuery<Episode> preparedQuery;
}

