package com.webworxshop.swallowcatcher;

import android.app.TabActivity;
import android.app.ProgressDialog;
import android.app.Dialog;
import android.app.AlertDialog;
import android.app.AlertDialog.Builder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.content.Intent;
import android.widget.TabHost;
import android.widget.TextView;
import android.widget.EditText;
import android.view.View;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MenuInflater;
import android.view.LayoutInflater;
import android.view.Window;
import android.content.Context;
import android.content.res.Resources;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.SharedPreferences;
import android.text.Html;
import android.util.Log;

import java.io.InputStream;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.sql.SQLException;
import java.util.Arrays;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.android.apptools.OpenHelperManager;

import com.webworxshop.swallowcatcher.feeds.FeedDownloadThread;
import com.webworxshop.swallowcatcher.db.Subscription;
import com.webworxshop.swallowcatcher.db.DatabaseHelper;

public class MainActivity extends TabActivity 
{
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_PROGRESS);
        setContentView(R.layout.main);
        
        Resources res = getResources();
        
        tabhost = getTabHost();
        Intent i1 = new Intent().setClass(this, PodcastsListActivity.class);
        Intent i2 = new Intent().setClass(this, DownloadsListActivity.class);
        tabhost.addTab(tabhost.newTabSpec("tab_podcasts").setIndicator(getString(R.string.tab_podcasts), res.getDrawable(R.drawable.tab_podcasts)).setContent(i1));                
        tabhost.addTab(tabhost.newTabSpec("tab_downloads").setIndicator(getString(R.string.tab_downloads), res.getDrawable(R.drawable.tab_downloads)).setContent(i2));

        tabhost.setCurrentTab(0);
        
        PodcastsListActivity.setMainActivity(this);
        OpmlImportActivity.setMainActivity(this);
        DownloadsListActivity.setMainActivity(this);
        
        // check version
        SharedPreferences settings = getSharedPreferences(PREFS_NAME, 0);
        if(settings.getString("version", "0.0.0").equals("0.0.0"))
        {
        	showLicence();        	
		}
		else if(!settings.getString("version", "0.0.0").equals(getString(R.string.version)))
		{
			showReleaseNotes();
		}
		
		Intent i = getIntent();
		if(i.getAction().equals(Intent.ACTION_VIEW))
		{
			try
			{
				final String url = validateURL(i.getDataString());
				Log.i("SwallowCatcher", "Adding feed: " + url);
				// add the feed
				AlertDialog.Builder builder = new AlertDialog.Builder(MainActivity.this);
				builder.setTitle("Subscribe to feed?").setMessage(url).setCancelable(false).setPositiveButton("Charge!", new DialogInterface.OnClickListener()
				{
					public void onClick(DialogInterface dialog, int id)
					{
						dialog.dismiss();
						addFeed(url);
					}
				})
				.setNegativeButton("Run Away!", new DialogInterface.OnClickListener()
				{
					public void onClick(DialogInterface dialog, int id)
					{
						dialog.dismiss();
					}
				});
				AlertDialog alert = builder.create();
				alert.show();
			}
			catch(RuntimeException e)
			{
				AlertDialog.Builder builder = new AlertDialog.Builder(MainActivity.this);
				builder.setTitle("Ne!").setMessage("URL Not Valid!").setCancelable(false).setPositiveButton("OK", new DialogInterface.OnClickListener()
				{
					public void onClick(DialogInterface dialog, int id)
					{
						dialog.dismiss();
					}
				});
				AlertDialog alert = builder.create();
				alert.show();
			}
		}
    }
    
    @Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
    	MenuInflater inflater = getMenuInflater();
    	inflater.inflate(R.menu.options, menu);
    	return true;
	}
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		switch (item.getItemId())
		{
			case R.id.refresh:
				startFeedRefresh(null);
				return true;
			case R.id.add_by_url:
				showAddByUrlDialog();
				return true;
			case R.id.add_by_barcode:
				startBarcodeScanner();
				return true;
			case R.id.add_by_opml:
				Intent opmlIntent = new Intent().setClass(getApplicationContext(), OpmlImportActivity.class);
    			startActivity(opmlIntent);
				return true;
			default:
				return super.onOptionsItemSelected(item);
		}
	}
	
	public void startBarcodeScanner()
	{
		// this is from: http://code.google.com/p/zxing/wiki/ScanningViaIntent
		Intent intent = new Intent("com.google.zxing.client.android.SCAN");
		intent.setPackage("com.google.zxing.client.android");
		intent.putExtra("SCAN_MODE", "QR_CODE_MODE");
		startActivityForResult(intent, 0);
	}
	
	public void showAddByUrlDialog()
	{
		final EditText t = new EditText(this);
	
		AlertDialog.Builder builder = new AlertDialog.Builder(MainActivity.this);
		builder.setTitle("Enter Feed URL:").setCancelable(false).setPositiveButton("Charge!", new DialogInterface.OnClickListener()
		{
			public void onClick(DialogInterface dialog, int id)
			{
				dialog.dismiss();
				
				String url = validateURL(t.getText().toString());
				addFeed(url);
			}
		})
		.setNegativeButton("Run Away!", new DialogInterface.OnClickListener()
		{
			public void onClick(DialogInterface dialog, int id)
			{
				dialog.dismiss();
			}
		}).setView(t);
		AlertDialog alert = builder.create();
		alert.show();
	}
	
	// this is from: http://code.google.com/p/zxing/wiki/ScanningViaIntent
	public void onActivityResult(int requestCode, int resultCode, Intent intent)
	{
		if (requestCode == 0)
		{
		    if (resultCode == RESULT_OK)
		    {
		        String contents = intent.getStringExtra("SCAN_RESULT");
		        String format = intent.getStringExtra("SCAN_RESULT_FORMAT");
		        
		        // Handle successful scan
		        try
		        {
		        	String url = validateURL(contents);
		        	addFeed(url);
		        }
		        catch(RuntimeException e)
				{
					AlertDialog.Builder builder = new AlertDialog.Builder(MainActivity.this);
					builder.setTitle("Ne!").setMessage("URL Not Valid!").setCancelable(false).setPositiveButton("OK", new DialogInterface.OnClickListener()
					{
						public void onClick(DialogInterface dialog, int id)
						{
							dialog.dismiss();
						}
					});
					AlertDialog alert = builder.create();
					alert.show();
				}
		    }
		}
	}
	
	protected Dialog onCreateDialog(int id)
	{
        switch(id)
        {
		    case REFRESH_PROGRESS_DIALOG:
		        progress = new ProgressDialog(MainActivity.this);
		        progress.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
		        progress.setMessage(getString(R.string.refreshing));
		        return progress;
		    default:
		        return null;
        }
    }
    
    public final Handler progress_handler = new Handler()
    {
        public void handleMessage(Message msg)
        {
            int p = msg.getData().getInt("progress");
            progress.incrementProgressBy(p);
            if (p >= 100 && !ep_activity_launched)
            {
            	progress.setProgress(0);
                dismissDialog(REFRESH_PROGRESS_DIALOG);
                
                Intent i = new Intent(MainActivity.this, EpisodesListActivity.class);
				i.putExtra("list_new", true);
				startActivity(i);
				ep_activity_launched = true;
            }
        }
    };
    
    public final Handler menu_handler = new Handler()
    {
    	public void handleMessage(Message msg)
        {
        	int i = msg.getData().getInt("item");
        	switch(i)
        	{
        		case ITEM_URL:
        			showAddByUrlDialog();
        			break;
        		case ITEM_BARCODE:
        			startBarcodeScanner();
        			break;
        		case ITEM_REFRESH:
        			try
        			{
        				DatabaseHelper helper = (DatabaseHelper)OpenHelperManager.getHelper(MainActivity.this);
						Dao<Subscription, Object> dao = helper.getSubscriptionDao();
						long id = msg.getData().getLong("feed");
						Subscription s = null;
						if(id != -1)
						{
							s = dao.queryForId(id);
						}
						startFeedRefresh(s);
					}
					catch(SQLException e)
					{
						Log.e("SwallowCatcher", "Unable to fiind subscription!", e);
					}
					break;
        	}
        }
    };
    
    public void showLicence()
    {
    	String text = readRawResource(R.raw.licence);
    	
    	LayoutInflater li = (LayoutInflater)getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    	View v = li.inflate(R.layout.startup_dialog_view, null);
    	TextView tv = (TextView)v.findViewById(R.id.dialog_text_view);
    	tv.setText(Html.fromHtml(text));
    	
    	AlertDialog.Builder builder = new AlertDialog.Builder(this);
    	builder.setView(v)
    		   .setTitle("Licence")
    		   .setCancelable(false)
			   .setPositiveButton("Accept", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int id)
					{
						dialog.dismiss();
						showReleaseNotes();
					}
   			   })
			   .setNegativeButton("Decline", new DialogInterface.OnClickListener() {
				   public void onClick(DialogInterface dialog, int id)
				   {
				   		// c'mon really, who declines the AGPL?
						MainActivity.this.finish();
				   }
			   });
		AlertDialog licence = builder.create();
		licence.show();
	}
    
    public void showReleaseNotes()
    {
    	String text = "<html><head></head><body><h2>" + getString(R.string.app_name) + " - " + getString(R.string.version) + "<br/>";
    	text += "\"" + getString(R.string.release_codename) + "\"</h2>";
    	text += readRawResource(R.raw.release_notes);
    	text += "</body></html>";
    	
    	LayoutInflater li = (LayoutInflater)getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    	View v = li.inflate(R.layout.startup_dialog_view, null);
    	TextView tv = (TextView)v.findViewById(R.id.dialog_text_view);
    	tv.setText(Html.fromHtml(text));
    	
    	AlertDialog.Builder builder = new AlertDialog.Builder(this);
    	builder.setView(v)
    		   .setTitle("Release Notes")
    		   .setCancelable(false)
			   .setPositiveButton("OK", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int id)
					{
						dialog.dismiss();
						// set the version to the current version
						SharedPreferences settings = getSharedPreferences(PREFS_NAME, 0);
						SharedPreferences.Editor editor = settings.edit();
						editor.putString("version", getString(R.string.version));
						editor.commit();
					}
   			   });
		AlertDialog release_notes = builder.create();
		release_notes.show();
    }
    
    public String readRawResource(int res_id)
    {
    	byte[] buffer = new byte[1024];
    	String text = "";
    	InputStream instream = getResources().openRawResource(res_id);
    	try
    	{
	    	while(instream.read(buffer) != -1)
	    	{
	    		text += new String(buffer);
	    		Arrays.fill(buffer, (byte)0);
	    	}
	    	instream.close();
	    	return text;
	    }
	    catch(IOException e)
	    {
	    	Log.e("SwallowCatcher", "Unable to read file!", e);
	    	return text;
	    }
    }
    
    public String validateURL(String data) throws RuntimeException
    {
    	Matcher m = URL_PATTERN_FEED.matcher(data);
		if(!m.matches())
		{
			m = URL_PATTERN_PODCAST.matcher(data);
		}
		String url = m.replaceFirst("http://");
		m = URL_PATTERN_MASTER.matcher(url);
		if(!m.matches())
		{
			throw new RuntimeException("URL doesn't pass validation!");
		}
		return url;
    }
    
    public void addFeed(String url)
    {
		try
		{
			DatabaseHelper helper = (DatabaseHelper)OpenHelperManager.getHelper(this);
			Dao<Subscription, Object> dao = helper.getSubscriptionDao();
		
			Subscription s = new Subscription(url);
			dao.create(s);
			
			// refresh the newly added feed
			startFeedRefresh(s);
			
			// refresh the subscription list activity
			onContentChanged();
			
		}
		catch(SQLException e)
		{
			Log.e("SwallowCatcher", "Unable to add subscription!", e);
		}
    }
    
    public void startFeedRefresh(Subscription sub)
    {
    	showDialog(REFRESH_PROGRESS_DIALOG);
		refresh_thread = new FeedDownloadThread(progress_handler, MainActivity.this, sub);
		refresh_thread.start();
		ep_activity_launched = false;
    }

    public static final int REFRESH_PROGRESS_DIALOG = 0;
    public static final String PREFS_NAME = "SwallowCatcher";
    private static final Pattern URL_PATTERN_PODCAST = Pattern.compile("podcast://");
    private static final Pattern URL_PATTERN_FEED = Pattern.compile("feed://");
    private static final Pattern URL_PATTERN_MASTER = Pattern.compile("(https?)://([\\w-]+\\.)+[\\w-]+(/[\\w-./?%&=]*)?(\\s*|$)", Pattern.CASE_INSENSITIVE);
    
    public static final int ITEM_URL = 0;
    public static final int ITEM_BARCODE  = 1;
    public static final int ITEM_REFRESH = 2;
    
    private TabHost tabhost;
    private ProgressDialog progress;
    private boolean ep_activity_launched = false;
    private FeedDownloadThread refresh_thread;
}

