/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.mapped.MappedPreparedStmt;
import java.sql.SQLException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseForeignCollection<T, ID>
implements ForeignCollection<T> {
    protected final Dao<T, ID> dao;
    protected final String fieldName;
    protected final Object fieldValue;
    private PreparedQuery<T> preparedQuery;
    private final String orderColumn;
    private final Object parent;

    public BaseForeignCollection(Dao<T, ID> dao, String fieldName, Object fieldValue, String orderColumn, Object parent) {
        this.dao = dao;
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
        this.orderColumn = orderColumn;
        this.parent = parent;
    }

    @Override
    public boolean add(T data) {
        try {
            this.dao.create(data);
            return true;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not create data element in dao", e);
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        for (T data : collection) {
            try {
                this.dao.create(data);
            }
            catch (SQLException e) {
                throw new IllegalStateException("Could not create data elements in dao", e);
            }
        }
        return true;
    }

    @Override
    public abstract boolean remove(Object var1);

    @Override
    public abstract boolean removeAll(Collection<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        CloseableIterator iterator = this.closeableIterator();
        try {
            while (iterator.hasNext()) {
                Object data = iterator.next();
                if (collection.contains(data)) continue;
                iterator.remove();
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            try {
                iterator.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        CloseableIterator iterator = this.closeableIterator();
        try {
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
        finally {
            try {
                iterator.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    protected PreparedQuery<T> getPreparedQuery() throws SQLException {
        if (this.preparedQuery == null) {
            SelectArg fieldArg = new SelectArg();
            fieldArg.setValue(this.fieldValue);
            QueryBuilder<T, ID> qb = this.dao.queryBuilder();
            if (this.orderColumn != null) {
                qb.orderBy(this.orderColumn, true);
            }
            this.preparedQuery = qb.where().eq(this.fieldName, fieldArg).prepare();
            if (this.preparedQuery instanceof MappedPreparedStmt) {
                MappedPreparedStmt mappedStmt = (MappedPreparedStmt)this.preparedQuery;
                mappedStmt.setParentObject(this.parent);
            }
        }
        return this.preparedQuery;
    }
}

