/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTable;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaoManager {
    private static Map<ClazzConnectionSource, Dao<?, ?>> classMap = null;
    private static Map<TableConfigConnectionSource, Dao<?, ?>> tableMap = null;

    public static synchronized <D extends Dao<T, ?>, T> D createDao(ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        ClazzConnectionSource key = new ClazzConnectionSource(connectionSource, clazz);
        Dao<?, ?> dao = DaoManager.lookupDao(key);
        if (dao != null) {
            Dao<?, ?> castDao = dao;
            return (D)castDao;
        }
        DatabaseTable databaseTable = clazz.getAnnotation(DatabaseTable.class);
        if (databaseTable == null || databaseTable.daoClass() == Void.class || databaseTable.daoClass() == BaseDaoImpl.class) {
            Dao daoTmp = BaseDaoImpl.createDao(connectionSource, clazz);
            dao = daoTmp;
        } else {
            Class<?>[] params;
            Constructor<?>[] constructors;
            Class<?> daoClass = databaseTable.daoClass();
            Constructor<?> daoConstructor = null;
            Object[] arguments = null;
            for (Constructor<?> constructor : constructors = daoClass.getConstructors()) {
                params = constructor.getParameterTypes();
                if (params.length != 2 || params[0] != ConnectionSource.class || params[1] != Class.class) continue;
                daoConstructor = constructor;
                arguments = new Object[]{connectionSource, clazz};
                break;
            }
            if (daoConstructor == null) {
                for (Constructor<?> constructor : constructors) {
                    params = constructor.getParameterTypes();
                    if (params.length != 1 || params[0] != ConnectionSource.class) continue;
                    daoConstructor = constructor;
                    arguments = new Object[]{connectionSource};
                    break;
                }
            }
            if (daoConstructor == null) {
                throw new SQLException("Could not find public constructor with ConnectionSource parameter in class " + daoClass);
            }
            try {
                dao = (Dao<?, ?>)daoConstructor.newInstance(arguments);
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not call the constructor in class " + daoClass, e);
            }
        }
        classMap.put(key, dao);
        Dao<Object, Object> castDao = dao;
        return (D)castDao;
    }

    public static synchronized <D extends Dao<T, ?>, T> D lookupDao(ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        ClazzConnectionSource key = new ClazzConnectionSource(connectionSource, clazz);
        Dao<?, ?> dao = DaoManager.lookupDao(key);
        if (dao == null) {
            return null;
        }
        Dao<?, ?> castDao = dao;
        return (D)castDao;
    }

    public static synchronized <D extends Dao<T, ?>, T> D createDao(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        TableConfigConnectionSource key = new TableConfigConnectionSource(connectionSource, tableConfig);
        Dao<?, ?> dao = DaoManager.lookupDao(key);
        if (dao != null) {
            Dao<?, ?> castDao = dao;
            return (D)castDao;
        }
        DatabaseTable databaseTable = tableConfig.getDataClass().getAnnotation(DatabaseTable.class);
        if (databaseTable == null || databaseTable.daoClass() == Void.class || databaseTable.daoClass() == BaseDaoImpl.class) {
            Dao daoTmp = BaseDaoImpl.createDao(connectionSource, tableConfig);
            dao = daoTmp;
        } else {
            Constructor<?> constructor;
            Class<?> daoClass = databaseTable.daoClass();
            try {
                constructor = daoClass.getConstructor(ConnectionSource.class, DatabaseTableConfig.class);
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not find public constructor with ConnectionSource, DatabaseTableConfig parameters in class " + daoClass, e);
            }
            try {
                dao = (Dao<?, ?>)constructor.newInstance(connectionSource, tableConfig);
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not call the constructor in class " + daoClass, e);
            }
        }
        tableMap.put(key, dao);
        Dao<Object, Object> castDao = dao;
        return (D)castDao;
    }

    public static synchronized <D extends Dao<T, ?>, T> D lookupDao(ConnectionSource connectionSource, DatabaseTableConfig<T> tableConfig) throws SQLException {
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        TableConfigConnectionSource key = new TableConfigConnectionSource(connectionSource, tableConfig);
        Dao<?, ?> dao = DaoManager.lookupDao(key);
        if (dao == null) {
            return null;
        }
        Dao<?, ?> castDao = dao;
        return (D)castDao;
    }

    public static synchronized void registerDao(ConnectionSource connectionSource, Dao<?, ?> dao) {
        DatabaseTableConfig tableConfig;
        if (connectionSource == null) {
            throw new IllegalArgumentException("connectionSource argument cannot be null");
        }
        if (dao instanceof BaseDaoImpl && (tableConfig = ((BaseDaoImpl)dao).getTableConfig()) != null) {
            tableMap.put(new TableConfigConnectionSource(connectionSource, tableConfig), dao);
            return;
        }
        classMap.put(new ClazzConnectionSource(connectionSource, dao.getDataClass()), dao);
    }

    public static synchronized void clearCache() {
        if (classMap != null) {
            classMap.clear();
            classMap = null;
        }
        if (tableMap != null) {
            tableMap.clear();
            tableMap = null;
        }
    }

    private static <T> Dao<?, ?> lookupDao(ClazzConnectionSource key) {
        Dao<?, ?> dao;
        if (classMap == null) {
            classMap = new HashMap();
        }
        if ((dao = classMap.get(key)) == null) {
            return null;
        }
        return dao;
    }

    private static <T> Dao<?, ?> lookupDao(TableConfigConnectionSource key) {
        Dao<?, ?> dao;
        if (tableMap == null) {
            tableMap = new HashMap();
        }
        if ((dao = tableMap.get(key)) == null) {
            return null;
        }
        return dao;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableConfigConnectionSource {
        ConnectionSource connectionSource;
        DatabaseTableConfig<?> tableConfig;

        public TableConfigConnectionSource(ConnectionSource connectionSource, DatabaseTableConfig<?> tableConfig) {
            this.connectionSource = connectionSource;
            this.tableConfig = tableConfig;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.tableConfig.hashCode();
            result = 31 * result + this.connectionSource.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TableConfigConnectionSource other = (TableConfigConnectionSource)obj;
            if (!this.tableConfig.equals(other.tableConfig)) {
                return false;
            }
            return this.connectionSource.equals(other.connectionSource);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClazzConnectionSource {
        ConnectionSource connectionSource;
        Class<?> clazz;

        public ClazzConnectionSource(ConnectionSource connectionSource, Class<?> clazz) {
            this.connectionSource = connectionSource;
            this.clazz = clazz;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + this.clazz.hashCode();
            result = 31 * result + this.connectionSource.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ClazzConnectionSource other = (ClazzConnectionSource)obj;
            if (!this.clazz.equals(other.clazz)) {
                return false;
            }
            return this.connectionSource.equals(other.connectionSource);
        }
    }
}

