/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import com.j256.ormlite.dao.BaseForeignCollection;
import com.j256.ormlite.dao.CloseableIterable;
import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.CloseableWrappedIterable;
import com.j256.ormlite.dao.CloseableWrappedIterableImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.ForeignCollection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyForeignCollection<T, ID>
extends BaseForeignCollection<T, ID>
implements ForeignCollection<T> {
    private CloseableIterator<T> lastIterator;

    public LazyForeignCollection(Dao<T, ID> dao, String fieldName, Object fieldValue, String orderColumn, Object parent) {
        super(dao, fieldName, fieldValue, orderColumn, parent);
    }

    @Override
    public CloseableIterator<T> iterator() {
        return this.closeableIterator();
    }

    @Override
    public CloseableIterator<T> closeableIterator() {
        try {
            return this.iteratorThrow();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not build lazy iterator for " + this.dao.getDataClass(), e);
        }
    }

    @Override
    public CloseableIterator<T> iteratorThrow() throws SQLException {
        this.lastIterator = this.seperateIteratorThrow();
        return this.lastIterator;
    }

    public CloseableIterator<T> seperateIteratorThrow() throws SQLException {
        return this.dao.iterator(this.getPreparedQuery());
    }

    @Override
    public CloseableWrappedIterable<T> getWrappedIterable() {
        return new CloseableWrappedIterableImpl(new CloseableIterable<T>(){

            @Override
            public CloseableIterator<T> iterator() {
                return this.closeableIterator();
            }

            @Override
            public CloseableIterator<T> closeableIterator() {
                try {
                    return LazyForeignCollection.this.seperateIteratorThrow();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not build lazy iterator for " + LazyForeignCollection.this.dao.getDataClass(), e);
                }
            }
        });
    }

    @Override
    public void closeLastIterator() throws SQLException {
        if (this.lastIterator != null) {
            this.lastIterator.close();
            this.lastIterator = null;
        }
    }

    @Override
    public boolean isEager() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        int sizeC = 0;
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                ++sizeC;
            }
            int n = sizeC;
            return n;
        }
        finally {
            try {
                iterator.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Iterator iterator = this.iterator();
        try {
            boolean bl = !iterator.hasNext();
            return bl;
        }
        finally {
            try {
                iterator.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object obj) {
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                if (!iterator.next().equals(obj)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                iterator.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        HashSet leftOvers = new HashSet(collection);
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                leftOvers.remove(iterator.next());
            }
            boolean bl = leftOvers.isEmpty();
            return bl;
        }
        finally {
            try {
                iterator.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object data) {
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                if (!iterator.next().equals(data)) continue;
                iterator.remove();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                iterator.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                iterator.remove();
                changed = true;
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            try {
                iterator.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ArrayList items = new ArrayList();
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                items.add(iterator.next());
            }
            Object[] objectArray = items.toArray();
            return objectArray;
        }
        finally {
            try {
                iterator.close();
            }
            catch (SQLException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> E[] toArray(E[] array) {
        ArrayList<E> items = null;
        int itemC = 0;
        Iterator iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                Object castData = iterator.next();
                if (itemC >= array.length) {
                    if (items == null) {
                        items = new ArrayList<E>();
                        for (E arrayData : array) {
                            items.add(arrayData);
                        }
                    }
                    items.add(castData);
                } else {
                    array[itemC] = castData;
                }
                ++itemC;
            }
        }
        finally {
            try {
                iterator.close();
            }
            catch (SQLException e) {}
        }
        if (items == null) {
            if (itemC < array.length - 1) {
                array[itemC] = null;
            }
            return array;
        }
        return items.toArray(array);
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

