/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.db;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataPersister;
import com.j256.ormlite.field.FieldConverter;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.DatabaseResults;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDatabaseType
implements DatabaseType {
    protected static String DEFAULT_SEQUENCE_SUFFIX = "_id_seq";
    protected Driver driver;

    protected abstract String getDriverClassName();

    protected abstract String getDatabaseName();

    @Override
    public void loadDriver() throws SQLException {
        String className = this.getDriverClassName();
        if (className != null) {
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw SqlExceptionUtil.create("Driver class was not found for " + this.getDatabaseName() + " database.  Missing jar with class " + className + ".", e);
            }
        }
    }

    @Override
    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    @Override
    public void appendColumnArg(StringBuilder sb, FieldType fieldType, List<String> additionalArgs, List<String> statementsBefore, List<String> statementsAfter, List<String> queriesAfter) throws SQLException {
        this.appendEscapedEntityName(sb, fieldType.getDbColumnName());
        sb.append(' ');
        DataPersister dataPersister = fieldType.getDataPersister();
        int fieldWidth = fieldType.getWidth();
        if (fieldWidth == 0) {
            fieldWidth = dataPersister.getDefaultWidth();
        }
        switch (dataPersister.getSqlType()) {
            case STRING: {
                this.appendStringType(sb, fieldWidth);
                break;
            }
            case LONG_STRING: {
                this.appendLongStringType(sb, fieldWidth);
                break;
            }
            case BOOLEAN: {
                this.appendBooleanType(sb, fieldWidth);
                break;
            }
            case DATE: {
                this.appendDateType(sb, fieldWidth);
                break;
            }
            case CHAR: {
                this.appendCharType(sb, fieldWidth);
                break;
            }
            case BYTE: {
                this.appendByteType(sb, fieldWidth);
                break;
            }
            case BYTE_ARRAY: {
                this.appendByteArrayType(sb, fieldWidth);
                break;
            }
            case SHORT: {
                this.appendShortType(sb, fieldWidth);
                break;
            }
            case INTEGER: {
                this.appendIntegerType(sb, fieldWidth);
                break;
            }
            case LONG: {
                this.appendLongType(sb, fieldWidth);
                break;
            }
            case FLOAT: {
                this.appendFloatType(sb, fieldWidth);
                break;
            }
            case DOUBLE: {
                this.appendDoubleType(sb, fieldWidth);
                break;
            }
            case SERIALIZABLE: {
                this.appendSerializableType(sb, fieldWidth);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SQL-type " + (Object)((Object)dataPersister.getSqlType()));
            }
        }
        sb.append(' ');
        if (fieldType.isGeneratedIdSequence() && !fieldType.isSelfGeneratedId()) {
            this.configureGeneratedIdSequence(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
        } else if (fieldType.isGeneratedId() && !fieldType.isSelfGeneratedId()) {
            this.configureGeneratedId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
        } else if (fieldType.isId()) {
            this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
        }
        if (!fieldType.isGeneratedId()) {
            Object defaultValue = fieldType.getDefaultValue();
            if (defaultValue != null) {
                sb.append("DEFAULT ");
                this.appendDefaultValue(sb, fieldType, defaultValue);
                sb.append(' ');
            }
            if (fieldType.isCanBeNull()) {
                this.appendCanBeNull(sb, fieldType);
            } else {
                sb.append("NOT NULL ");
            }
            if (fieldType.isUnique()) {
                this.addSingleUnique(sb, fieldType, additionalArgs, statementsAfter);
            }
        }
    }

    protected void appendStringType(StringBuilder sb, int fieldWidth) {
        if (this.isVarcharFieldWidthSupported()) {
            sb.append("VARCHAR(").append(fieldWidth).append(")");
        } else {
            sb.append("VARCHAR");
        }
    }

    protected void appendLongStringType(StringBuilder sb, int fieldWidth) {
        sb.append("TEXT");
    }

    protected void appendDateType(StringBuilder sb, int fieldWidth) {
        sb.append("TIMESTAMP");
    }

    protected void appendBooleanType(StringBuilder sb, int fieldWidth) {
        sb.append("BOOLEAN");
    }

    protected void appendCharType(StringBuilder sb, int fieldWidth) {
        sb.append("CHAR");
    }

    protected void appendByteType(StringBuilder sb, int fieldWidth) {
        sb.append("TINYINT");
    }

    protected void appendShortType(StringBuilder sb, int fieldWidth) {
        sb.append("SMALLINT");
    }

    protected void appendIntegerType(StringBuilder sb, int fieldWidth) {
        sb.append("INTEGER");
    }

    protected void appendLongType(StringBuilder sb, int fieldWidth) {
        sb.append("BIGINT");
    }

    protected void appendFloatType(StringBuilder sb, int fieldWidth) {
        sb.append("FLOAT");
    }

    protected void appendDoubleType(StringBuilder sb, int fieldWidth) {
        sb.append("DOUBLE PRECISION");
    }

    protected void appendByteArrayType(StringBuilder sb, int fieldWidth) {
        sb.append("BLOB");
    }

    protected void appendSerializableType(StringBuilder sb, int fieldWidth) {
        sb.append("BLOB");
    }

    protected void appendDefaultValue(StringBuilder sb, FieldType fieldType, Object defaultValue) {
        if (fieldType.isEscapedDefaultValue()) {
            this.appendEscapedWord(sb, defaultValue.toString());
        } else {
            sb.append(defaultValue);
        }
    }

    protected void configureGeneratedIdSequence(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) throws SQLException {
        throw new SQLException("GeneratedIdSequence is not supported by database " + this.getDatabaseName() + " for field " + fieldType);
    }

    protected void configureGeneratedId(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        throw new IllegalStateException("GeneratedId is not supported by database " + this.getDatabaseName() + " for field " + fieldType);
    }

    protected void configureId(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
    }

    @Override
    public void addPrimaryKeySql(FieldType[] fieldTypes, List<String> additionalArgs, List<String> statementsBefore, List<String> statementsAfter, List<String> queriesAfter) throws SQLException {
        StringBuilder sb = null;
        for (FieldType fieldType : fieldTypes) {
            if (fieldType.isGeneratedId() && !this.generatedIdSqlAtEnd() || !fieldType.isId()) continue;
            if (sb == null) {
                sb = new StringBuilder(48);
                sb.append("PRIMARY KEY (");
            } else {
                sb.append(',');
            }
            this.appendEscapedEntityName(sb, fieldType.getDbColumnName());
        }
        if (sb != null) {
            sb.append(") ");
            additionalArgs.add(sb.toString());
        }
    }

    protected boolean generatedIdSqlAtEnd() {
        return true;
    }

    @Override
    public void addUniqueComboSql(FieldType[] fieldTypes, List<String> additionalArgs, List<String> statementsBefore, List<String> statementsAfter, List<String> queriesAfter) throws SQLException {
        StringBuilder sb = null;
        for (FieldType fieldType : fieldTypes) {
            if (!fieldType.isUniqueCombo()) continue;
            if (sb == null) {
                sb = new StringBuilder(48);
                sb.append("UNIQUE (");
            } else {
                sb.append(',');
            }
            this.appendEscapedEntityName(sb, fieldType.getDbColumnName());
        }
        if (sb != null) {
            sb.append(") ");
            additionalArgs.add(sb.toString());
        }
    }

    @Override
    public void dropColumnArg(FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter) {
    }

    @Override
    public void appendEscapedWord(StringBuilder sb, String word) {
        sb.append('\'').append(word).append('\'');
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String word) {
        sb.append('`').append(word).append('`');
    }

    @Override
    public String generateIdSequenceName(String tableName, FieldType idFieldType) {
        String name = tableName + DEFAULT_SEQUENCE_SUFFIX;
        if (this.isEntityNamesMustBeUpCase()) {
            return name.toUpperCase();
        }
        return name;
    }

    @Override
    public String getCommentLinePrefix() {
        return "-- ";
    }

    @Override
    public FieldConverter getFieldConverter(DataPersister dataPersister) {
        return dataPersister;
    }

    @Override
    public boolean isIdSequenceNeeded() {
        return false;
    }

    @Override
    public boolean isVarcharFieldWidthSupported() {
        return true;
    }

    @Override
    public boolean isLimitSqlSupported() {
        return true;
    }

    @Override
    public boolean isOffsetSqlSupported() {
        return true;
    }

    @Override
    public boolean isOffsetLimitArgument() {
        return false;
    }

    @Override
    public boolean isLimitAfterSelect() {
        return false;
    }

    @Override
    public void appendLimitValue(StringBuilder sb, int limit, Integer offset) {
        sb.append("LIMIT ").append(limit).append(' ');
    }

    @Override
    public void appendOffsetValue(StringBuilder sb, int offset) {
        sb.append("OFFSET ").append(offset).append(' ');
    }

    @Override
    public void appendSelectNextValFromSequence(StringBuilder sb, String sequenceName) {
    }

    @Override
    public void appendCreateTableSuffix(StringBuilder sb) {
    }

    @Override
    public boolean isCreateTableReturnsZero() {
        return true;
    }

    @Override
    public boolean isEntityNamesMustBeUpCase() {
        return false;
    }

    @Override
    public boolean isNestedSavePointsSupported() {
        return true;
    }

    @Override
    public String getPingStatement() {
        return "SELECT 1";
    }

    @Override
    public boolean isBatchUseTransaction() {
        return false;
    }

    @Override
    public boolean isTruncateSupported() {
        return false;
    }

    @Override
    public boolean isCreateIfNotExistsSupported() {
        return false;
    }

    @Override
    public boolean isSelectSequenceBeforeInsert() {
        return false;
    }

    protected void appendCanBeNull(StringBuilder sb, FieldType fieldType) {
    }

    protected void addSingleUnique(StringBuilder sb, FieldType fieldType, List<String> additionalArgs, List<String> statementsAfter) {
        StringBuilder alterSb = new StringBuilder();
        alterSb.append(" UNIQUE (");
        this.appendEscapedEntityName(alterSb, fieldType.getDbColumnName());
        alterSb.append(")");
        additionalArgs.add(alterSb.toString());
    }

    protected static class BooleanNumberFieldConverter
    implements FieldConverter {
        protected BooleanNumberFieldConverter() {
        }

        public SqlType getSqlType() {
            return SqlType.BOOLEAN;
        }

        public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
            boolean bool = Boolean.parseBoolean(defaultStr);
            return bool ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        }

        public Object javaToSqlArg(FieldType fieldType, Object obj) throws SQLException {
            Boolean bool = (Boolean)obj;
            return bool != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        }

        public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            byte result = results.getByte(columnPos);
            return result == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }

        public boolean isStreamType() {
            return false;
        }
    }
}

