/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.BaseForeignCollection;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.dao.EagerForeignCollection;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.dao.LazyForeignCollection;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DataPersister;
import com.j256.ormlite.field.DataPersisterManager;
import com.j256.ormlite.field.DataType;
import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.field.FieldConverter;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.VoidType;
import com.j256.ormlite.misc.BaseDaoEnabled;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.stmt.mapped.MappedQueryForId;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableInfo;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldType {
    public static final String FOREIGN_ID_FIELD_SUFFIX = "_id";
    private static boolean DEFAULT_VALUE_BOOLEAN;
    private static byte DEFAULT_VALUE_BYTE;
    private static char DEFAULT_VALUE_CHAR;
    private static short DEFAULT_VALUE_SHORT;
    private static int DEFAULT_VALUE_INT;
    private static long DEFAULT_VALUE_LONG;
    private static float DEFAULT_VALUE_FLOAT;
    private static double DEFAULT_VALUE_DOUBLE;
    private final ConnectionSource connectionSource;
    private final Field field;
    private final String dbColumnName;
    private final DatabaseFieldConfig fieldConfig;
    private final boolean isId;
    private final boolean isGeneratedId;
    private final String generatedIdSequence;
    private final Method fieldGetMethod;
    private final Method fieldSetMethod;
    private DataPersister dataPersister;
    private Object defaultValue;
    private Object dataTypeConfigObj;
    private FieldConverter fieldConverter;
    private FieldType foreignIdField;
    private Constructor<?> foreignConstructor;
    private FieldType foreignFieldType;
    private Dao<?, ?> foreignDao;
    private MappedQueryForId<Object, Object> mappedQueryForId;
    private static final ThreadLocal<LevelCounters> threadLevelCounters;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FieldType(ConnectionSource connectionSource, String tableName, Field field, DatabaseFieldConfig fieldConfig, Class<?> parentClass) throws SQLException {
        DataPersister dataPersister;
        Class<?> clazz;
        DatabaseType databaseType;
        block35: {
            block34: {
                this.connectionSource = connectionSource;
                databaseType = connectionSource.getDatabaseType();
                this.field = field;
                clazz = field.getType();
                if (fieldConfig.getDataPersister() != null) break block34;
                Class<? extends DataPersister> persisterClass = fieldConfig.getPersisterClass();
                if (persisterClass == null || persisterClass == VoidType.class) {
                    dataPersister = DataPersisterManager.lookupForField(field);
                    break block35;
                } else {
                    DataPersister result;
                    Method method;
                    try {
                        method = persisterClass.getDeclaredMethod("getSingleton", new Class[0]);
                    }
                    catch (Exception e) {
                        throw SqlExceptionUtil.create("Could not find getSingleton static method on class " + persisterClass, e);
                    }
                    try {
                        result = (DataPersister)method.invoke(null, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        throw SqlExceptionUtil.create("Could not run getSingleton method on class " + persisterClass, e.getTargetException());
                    }
                    catch (Exception e) {
                        throw SqlExceptionUtil.create("Could not run getSingleton method on class " + persisterClass, e);
                    }
                    if (result == null) {
                        throw new SQLException("Static getSingleton method should not return null on class " + persisterClass);
                    }
                    try {
                        dataPersister = result;
                    }
                    catch (Exception e) {
                        throw new SQLException("Could not cast result of static getSingleton method to DataPersister from class " + persisterClass);
                    }
                }
            }
            dataPersister = fieldConfig.getDataPersister();
            if (!dataPersister.isValidForField(field)) {
                throw new IllegalArgumentException("Field class " + clazz + " for field " + this + " is not valid for data persister " + dataPersister);
            }
        }
        String defaultFieldName = field.getName();
        if (fieldConfig.isForeign() || fieldConfig.isForeignAutoRefresh()) {
            if (dataPersister != null && dataPersister.isPrimitive()) {
                throw new IllegalArgumentException("Field " + this + " is a primitive class " + clazz + " but marked as foreign");
            }
            defaultFieldName = defaultFieldName + FOREIGN_ID_FIELD_SUFFIX;
        } else if (fieldConfig.isForeignCollection()) {
            if (clazz != Collection.class && !ForeignCollection.class.isAssignableFrom(clazz)) {
                throw new SQLException("Field class for '" + field.getName() + "' must be of class " + ForeignCollection.class.getSimpleName() + " or Collection.");
            }
            Type type = field.getGenericType();
            if (!(type instanceof ParameterizedType)) {
                throw new SQLException("Field class for '" + field.getName() + "' must be a parameterized Collection.");
            }
            Type[] genericArguments = ((ParameterizedType)type).getActualTypeArguments();
            if (genericArguments.length == 0) {
                throw new SQLException("Field class for '" + field.getName() + "' must be a parameterized Collection with at least 1 type.");
            }
        } else if (dataPersister == null && !fieldConfig.isForeignCollection()) {
            if (byte[].class.isAssignableFrom(clazz)) {
                throw new SQLException("ORMLite can't store unknown class " + clazz + " for field '" + field.getName() + "'. byte[] fields must specify dataType=DataType.BYTE_ARRAY or SERIALIZABLE");
            }
            if (Serializable.class.isAssignableFrom(clazz)) {
                throw new SQLException("ORMLite can't store unknown class " + clazz + " for field '" + field.getName() + "'. Serializable fields must specify dataType=DataType.SERIALIZABLE");
            }
            throw new IllegalArgumentException("ORMLite does not know how to store field class " + clazz + " for field " + this);
        }
        this.dbColumnName = fieldConfig.getColumnName() == null ? defaultFieldName : fieldConfig.getColumnName();
        this.fieldConfig = fieldConfig;
        if (fieldConfig.isId()) {
            if (fieldConfig.isGeneratedId() || fieldConfig.getGeneratedIdSequence() != null) {
                throw new IllegalArgumentException("Must specify one of id, generatedId, and generatedIdSequence with " + field.getName());
            }
            this.isId = true;
            this.isGeneratedId = false;
            this.generatedIdSequence = null;
        } else if (fieldConfig.isGeneratedId()) {
            if (fieldConfig.getGeneratedIdSequence() != null) {
                throw new IllegalArgumentException("Must specify one of id, generatedId, and generatedIdSequence with " + field.getName());
            }
            this.isId = true;
            this.isGeneratedId = true;
            this.generatedIdSequence = databaseType.isIdSequenceNeeded() ? databaseType.generateIdSequenceName(tableName, this) : null;
        } else if (fieldConfig.getGeneratedIdSequence() != null) {
            this.isId = true;
            this.isGeneratedId = true;
            String seqName = fieldConfig.getGeneratedIdSequence();
            if (databaseType.isEntityNamesMustBeUpCase()) {
                seqName = seqName.toUpperCase();
            }
            this.generatedIdSequence = seqName;
        } else {
            this.isId = false;
            this.isGeneratedId = false;
            this.generatedIdSequence = null;
        }
        if (this.isId && (fieldConfig.isForeign() || fieldConfig.isForeignAutoRefresh())) {
            throw new IllegalArgumentException("Id field " + field.getName() + " cannot also be a foreign object");
        }
        if (fieldConfig.isUseGetSet()) {
            this.fieldGetMethod = DatabaseFieldConfig.findGetMethod(field, true);
            this.fieldSetMethod = DatabaseFieldConfig.findSetMethod(field, true);
        } else {
            this.fieldGetMethod = null;
            this.fieldSetMethod = null;
        }
        this.assignDataType(databaseType, dataPersister);
    }

    public void configDaoInformation(ConnectionSource connectionSource, Class<?> parentClass) throws SQLException {
        FieldType foreignFieldType;
        Constructor<Object> foreignConstructor;
        MappedQueryForId mappedQueryForId;
        FieldType foreignIdField;
        BaseDaoImpl foreignDao;
        Class clazz = this.field.getType();
        DatabaseType databaseType = connectionSource.getDatabaseType();
        if (this.fieldConfig.isForeignAutoRefresh()) {
            MappedQueryForId castMappedQueryForId;
            TableInfo foreignTableInfo;
            DatabaseTableConfig<?> tableConfig = this.fieldConfig.getForeignTableConfig();
            if (tableConfig == null) {
                foreignDao = (BaseDaoImpl)DaoManager.createDao(connectionSource, clazz);
                foreignTableInfo = foreignDao.getTableInfo();
            } else {
                tableConfig.extractFieldTypes(connectionSource);
                foreignDao = (BaseDaoImpl)DaoManager.createDao(connectionSource, tableConfig);
                foreignTableInfo = foreignDao.getTableInfo();
            }
            foreignIdField = foreignTableInfo.getIdField();
            if (foreignIdField == null) {
                throw new IllegalArgumentException("Foreign field " + clazz + " does not have id field");
            }
            mappedQueryForId = castMappedQueryForId = MappedQueryForId.build(databaseType, foreignTableInfo);
            foreignConstructor = foreignTableInfo.getConstructor();
            foreignFieldType = null;
        } else if (this.fieldConfig.isForeign()) {
            if (this.dataPersister != null && this.dataPersister.isPrimitive()) {
                throw new IllegalArgumentException("Field " + this + " is a primitive class " + clazz + " but marked as foreign");
            }
            DatabaseTableConfig<?> tableConfig = this.fieldConfig.getForeignTableConfig();
            if (tableConfig != null) {
                tableConfig.extractFieldTypes(connectionSource);
                foreignDao = (BaseDaoImpl)DaoManager.createDao(connectionSource, tableConfig);
                TableInfo foreignTableInfo = foreignDao.getTableInfo();
                foreignIdField = foreignTableInfo.getIdField();
                foreignConstructor = foreignTableInfo.getConstructor();
            } else if (BaseDaoEnabled.class.isAssignableFrom(clazz)) {
                foreignDao = (BaseDaoImpl)DaoManager.createDao(connectionSource, clazz);
                TableInfo foreignTableInfo = foreignDao.getTableInfo();
                foreignIdField = foreignTableInfo.getIdField();
                foreignConstructor = foreignTableInfo.getConstructor();
            } else {
                foreignDao = null;
                foreignIdField = DatabaseTableConfig.extractIdFieldType(connectionSource, clazz, DatabaseTableConfig.extractTableName(clazz));
                foreignConstructor = DatabaseTableConfig.findNoArgConstructor(clazz);
            }
            if (foreignIdField == null) {
                throw new IllegalArgumentException("Foreign field " + clazz + " does not have id field");
            }
            foreignFieldType = null;
            mappedQueryForId = null;
        } else if (this.fieldConfig.isForeignCollection()) {
            Object castDao;
            if (clazz != Collection.class && !ForeignCollection.class.isAssignableFrom(clazz)) {
                throw new SQLException("Field class for '" + this.field.getName() + "' must be of class " + ForeignCollection.class.getSimpleName() + " or Collection.");
            }
            Type type = this.field.getGenericType();
            if (!(type instanceof ParameterizedType)) {
                throw new SQLException("Field class for '" + this.field.getName() + "' must be a parameterized Collection.");
            }
            Type[] genericArguments = ((ParameterizedType)type).getActualTypeArguments();
            if (genericArguments.length == 0) {
                throw new SQLException("Field class for '" + this.field.getName() + "' must be a parameterized Collection with at least 1 type.");
            }
            clazz = (Class)genericArguments[0];
            DatabaseTableConfig<?> tableConfig = this.fieldConfig.getForeignTableConfig();
            Object foundDao = tableConfig == null ? (castDao = DaoManager.createDao(connectionSource, clazz)) : (castDao = DaoManager.createDao(connectionSource, tableConfig));
            FieldType findForeignFieldType = null;
            for (FieldType fieldType : ((BaseDaoImpl)foundDao).getTableInfo().getFieldTypes()) {
                if (fieldType.getFieldType() != parentClass) continue;
                findForeignFieldType = fieldType;
                break;
            }
            if (findForeignFieldType == null) {
                throw new SQLException("Foreign collection object " + clazz + " for field '" + this.field.getName() + "' does not contain a foreign field of class " + parentClass);
            }
            if (!findForeignFieldType.fieldConfig.isForeign() && !findForeignFieldType.fieldConfig.isForeignAutoRefresh()) {
                throw new SQLException("Foreign collection object " + clazz + " for field '" + this.field.getName() + "' contains a field of class " + parentClass + " but it's not foreign");
            }
            foreignDao = foundDao;
            foreignFieldType = findForeignFieldType;
            foreignIdField = null;
            foreignConstructor = null;
            mappedQueryForId = null;
        } else {
            foreignConstructor = null;
            foreignIdField = null;
            foreignFieldType = null;
            foreignDao = null;
            mappedQueryForId = null;
        }
        this.mappedQueryForId = mappedQueryForId;
        this.foreignConstructor = foreignConstructor;
        this.foreignFieldType = foreignFieldType;
        this.foreignDao = foreignDao;
        this.foreignIdField = foreignIdField;
        if (foreignIdField != null) {
            this.assignDataType(databaseType, foreignIdField.getDataPersister());
        }
    }

    public Field getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public String getDbColumnName() {
        return this.dbColumnName;
    }

    public DataPersister getDataPersister() {
        return this.dataPersister;
    }

    public Object getDataTypeConfigObj() {
        return this.dataTypeConfigObj;
    }

    public SqlType getSqlType() {
        return this.fieldConverter.getSqlType();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public int getWidth() {
        return this.fieldConfig.getWidth();
    }

    public boolean isCanBeNull() {
        return this.fieldConfig.isCanBeNull();
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isGeneratedId() {
        return this.isGeneratedId;
    }

    public boolean isGeneratedIdSequence() {
        return this.generatedIdSequence != null;
    }

    public String getGeneratedIdSequence() {
        return this.generatedIdSequence;
    }

    public boolean isForeign() {
        return this.fieldConfig.isForeign();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignField(Object data, Object val, boolean parentObject) throws SQLException {
        if (this.foreignIdField != null && val != null) {
            Object foreignId = this.extractJavaFieldValue(data);
            if (foreignId != null && foreignId.equals(val)) {
                return;
            }
            if (!parentObject) {
                Object foreignObject;
                LevelCounters levelCounters = this.getLevelCounters();
                if (this.mappedQueryForId == null || levelCounters.autoRefreshlevel >= this.fieldConfig.getMaxForeignAutoRefreshLevel()) {
                    foreignObject = TableInfo.createObject(this.foreignConstructor, this.foreignDao);
                    this.foreignIdField.assignField(foreignObject, val, false);
                } else {
                    ++levelCounters.autoRefreshlevel;
                    try {
                        DatabaseConnection databaseConnection = this.connectionSource.getReadOnlyConnection();
                        try {
                            foreignObject = this.mappedQueryForId.execute(databaseConnection, val);
                        }
                        finally {
                            this.connectionSource.releaseConnection(databaseConnection);
                        }
                    }
                    finally {
                        --levelCounters.autoRefreshlevel;
                    }
                }
                val = foreignObject;
            }
        }
        if (this.fieldSetMethod == null) {
            boolean accessible = this.field.isAccessible();
            if (!accessible) {
                this.field.setAccessible(true);
            }
            try {
                this.field.set(data, val);
            }
            catch (IllegalArgumentException e) {
                throw SqlExceptionUtil.create("Could not assign object '" + val + "' to field " + this, e);
            }
            catch (IllegalAccessException e) {
                throw SqlExceptionUtil.create("Could not assign object '" + val + "' to field " + this, e);
            }
            finally {
                if (!accessible) {
                    this.field.setAccessible(false);
                }
            }
        }
        try {
            this.fieldSetMethod.invoke(data, val);
        }
        catch (Exception e) {
            throw SqlExceptionUtil.create("Could not call " + this.fieldSetMethod + " on object with '" + val + "' for " + this, e);
        }
    }

    public Object assignIdValue(Object data, Number val) throws SQLException {
        Object idVal = this.dataPersister.convertIdNumber(val);
        if (idVal == null) {
            throw new SQLException("Invalid class " + this.dataPersister + " for sequence-id " + this);
        }
        this.assignField(data, idVal, false);
        return idVal;
    }

    public <FV> FV extractJavaFieldValue(Object object) throws SQLException {
        Object val;
        if (this.fieldGetMethod == null) {
            boolean accessible = this.field.isAccessible();
            try {
                if (!accessible) {
                    this.field.setAccessible(true);
                }
                val = this.field.get(object);
            }
            catch (Exception e) {
                throw SqlExceptionUtil.create("Could not get field value for " + this, e);
            }
            finally {
                if (!accessible) {
                    this.field.setAccessible(false);
                }
            }
        }
        try {
            val = this.fieldGetMethod.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw SqlExceptionUtil.create("Could not call " + this.fieldGetMethod + " for " + this, e);
        }
        if (val == null) {
            return null;
        }
        if (this.foreignIdField != null) {
            val = this.foreignIdField.extractJavaFieldValue(val);
        }
        Object converted = val;
        return (FV)converted;
    }

    public Object extractJavaFieldToSqlArgValue(Object object) throws SQLException {
        return this.convertJavaFieldToSqlArgValue(this.extractJavaFieldValue(object));
    }

    public <FV> FV convertJavaFieldToSqlArgValue(Object fieldVal) throws SQLException {
        if (fieldVal == null) {
            return null;
        }
        Object converted = fieldVal = this.fieldConverter.javaToSqlArg(this, fieldVal);
        return (FV)converted;
    }

    public FieldType getForeignIdField() throws SQLException {
        return this.foreignIdField;
    }

    public boolean isEscapedValue() {
        return this.dataPersister.isEscapedValue();
    }

    public Enum<?> getUnknownEnumVal() {
        return this.fieldConfig.getUnknownEnumvalue();
    }

    public String getFormat() {
        return this.fieldConfig.getFormat();
    }

    public boolean isUnique() {
        return this.fieldConfig.isUnique();
    }

    public boolean isUniqueCombo() {
        return this.fieldConfig.isUniqueCombo();
    }

    public String getIndexName() {
        return this.fieldConfig.getIndexName();
    }

    public String getUniqueIndexName() {
        return this.fieldConfig.getUniqueIndexName();
    }

    public boolean isEscapedDefaultValue() {
        return this.dataPersister.isEscapedDefaultValue();
    }

    public boolean isComparable() {
        return this.dataPersister.isComparable();
    }

    public boolean isArgumentHolderRequired() {
        return this.dataPersister.isSelectArgRequired();
    }

    public boolean isForeignCollection() {
        return this.fieldConfig.isForeignCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <FT, FID> BaseForeignCollection<FT, FID> buildForeignCollection(FT parent, Object id, boolean forceEager) throws SQLException {
        if (this.foreignFieldType == null) {
            return null;
        }
        Dao<?, ?> castDao = this.foreignDao;
        if (!this.fieldConfig.isForeignCollectionEager() && !forceEager) {
            return new LazyForeignCollection(castDao, this.foreignFieldType.dbColumnName, id, this.fieldConfig.getForeignCollectionOrderColumn(), parent);
        }
        LevelCounters levelCounters = this.getLevelCounters();
        if (levelCounters.foreignCollectionLevel >= this.fieldConfig.getMaxEagerForeignCollectionLevel()) {
            return new LazyForeignCollection(castDao, this.foreignFieldType.dbColumnName, id, this.fieldConfig.getForeignCollectionOrderColumn(), parent);
        }
        ++levelCounters.foreignCollectionLevel;
        try {
            EagerForeignCollection eagerForeignCollection = new EagerForeignCollection(castDao, parent, this.foreignFieldType, id, this.fieldConfig.getForeignCollectionOrderColumn());
            return eagerForeignCollection;
        }
        finally {
            --levelCounters.foreignCollectionLevel;
        }
    }

    public <T> T resultToJava(DatabaseResults results, Map<String, Integer> columnPositions) throws SQLException {
        Integer dbColumnPos = columnPositions.get(this.dbColumnName);
        if (dbColumnPos == null) {
            dbColumnPos = results.findColumn(this.dbColumnName);
            columnPositions.put(this.dbColumnName, dbColumnPos);
        }
        Object converted = this.fieldConverter.resultToJava(this, results, dbColumnPos);
        if (this.dataPersister.isPrimitive()) {
            if (this.fieldConfig.isThrowIfNull() && results.wasNull(dbColumnPos)) {
                throw new SQLException("Results value for primitive field '" + this.field.getName() + "' was an invalid null value");
            }
        } else if (!this.fieldConverter.isStreamType() && results.wasNull(dbColumnPos)) {
            return null;
        }
        return (T)converted;
    }

    public boolean isSelfGeneratedId() {
        return this.dataPersister.isSelfGeneratedId();
    }

    public Object generatedId() {
        return this.dataPersister.generatedId();
    }

    public <FV> FV getFieldValueIfNotDefault(Object object) throws SQLException {
        FV fieldValue = this.extractJavaFieldValue(object);
        if (fieldValue == null) {
            return null;
        }
        boolean isDefault = this.field.getType() == Boolean.TYPE ? fieldValue.equals(DEFAULT_VALUE_BOOLEAN) : (this.field.getType() == Byte.TYPE || this.field.getType() == Byte.class ? fieldValue.equals(DEFAULT_VALUE_BYTE) : (this.field.getType() == Character.TYPE || this.field.getType() == Character.class ? fieldValue.equals(Character.valueOf(DEFAULT_VALUE_CHAR)) : (this.field.getType() == Short.TYPE || this.field.getType() == Short.class ? fieldValue.equals(DEFAULT_VALUE_SHORT) : (this.field.getType() == Integer.TYPE || this.field.getType() == Integer.class ? fieldValue.equals(DEFAULT_VALUE_INT) : (this.field.getType() == Long.TYPE || this.field.getType() == Long.class ? fieldValue.equals(DEFAULT_VALUE_LONG) : (this.field.getType() == Float.TYPE || this.field.getType() == Float.class ? fieldValue.equals(Float.valueOf(DEFAULT_VALUE_FLOAT)) : (this.field.getType() == Double.TYPE || this.field.getType() == Double.class ? fieldValue.equals(DEFAULT_VALUE_DOUBLE) : false)))))));
        if (isDefault) {
            return null;
        }
        return fieldValue;
    }

    public static FieldType createFieldType(ConnectionSource connectionSource, String tableName, Field field, Class<?> parentClass) throws SQLException {
        DatabaseType databaseType = connectionSource.getDatabaseType();
        DatabaseFieldConfig fieldConfig = DatabaseFieldConfig.fromField(databaseType, tableName, field);
        if (fieldConfig == null) {
            return null;
        }
        return new FieldType(connectionSource, tableName, field, fieldConfig, parentClass);
    }

    public boolean equals(Object arg) {
        if (arg == null || arg.getClass() != this.getClass()) {
            return false;
        }
        FieldType other = (FieldType)arg;
        return this.field.equals(other.field);
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":name=" + this.field.getName() + ",class=" + this.field.getDeclaringClass().getSimpleName();
    }

    private void assignDataType(DatabaseType databaseType, DataPersister dataPersister) throws SQLException {
        this.dataPersister = dataPersister;
        if (dataPersister == null) {
            return;
        }
        this.fieldConverter = databaseType.getFieldConverter(dataPersister);
        if (this.isGeneratedId && !dataPersister.isValidGeneratedType()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Generated-id field '").append(this.field.getName());
            sb.append("' in ").append(this.field.getDeclaringClass().getSimpleName());
            sb.append(" can't be type ").append((Object)this.dataPersister.getSqlType());
            sb.append(".  Must be one of: ");
            for (DataType dataType : DataType.values()) {
                DataPersister persister = dataType.getDataPersister();
                if (persister == null || !persister.isValidGeneratedType()) continue;
                sb.append((Object)dataType).append(' ');
            }
            throw new IllegalArgumentException(sb.toString());
        }
        if (this.fieldConfig.isThrowIfNull() && !dataPersister.isPrimitive()) {
            throw new SQLException("Field " + this.field.getName() + " must be a primitive if set with throwIfNull");
        }
        if (this.isId && !dataPersister.isAppropriateId()) {
            throw new SQLException("Field '" + this.field.getName() + "' is of data type " + dataPersister + " which cannot be the ID field");
        }
        this.dataTypeConfigObj = dataPersister.makeConfigObject(this);
        String defaultStr = this.fieldConfig.getDefaultValue();
        if (defaultStr == null || defaultStr.equals("")) {
            this.defaultValue = null;
        } else {
            if (this.isGeneratedId) {
                throw new SQLException("Field '" + this.field.getName() + "' cannot be a generatedId and have a default value '" + defaultStr + "'");
            }
            this.defaultValue = this.fieldConverter.parseDefaultString(this, defaultStr);
        }
    }

    private LevelCounters getLevelCounters() {
        LevelCounters levelCounters = threadLevelCounters.get();
        if (levelCounters == null) {
            levelCounters = new LevelCounters();
            threadLevelCounters.set(levelCounters);
        }
        return levelCounters;
    }

    static {
        threadLevelCounters = new ThreadLocal();
    }

    private static class LevelCounters {
        int autoRefreshlevel;
        int foreignCollectionLevel;

        private LevelCounters() {
        }
    }
}

