/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDateType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.DatabaseResults;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;

public class DateStringType
extends BaseDateType {
    public static int DEFAULT_WIDTH = 50;
    private static final DateStringType singleTon = new DateStringType();

    public static DateStringType getSingleton() {
        return singleTon;
    }

    private DateStringType() {
        super(SqlType.STRING, new Class[0]);
    }

    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        BaseDateType.DateStringFormatConfig formatConfig = DateStringType.convertDateStringConfig(fieldType);
        try {
            return DateStringType.normalizeDateString(formatConfig, defaultStr);
        }
        catch (ParseException e) {
            throw SqlExceptionUtil.create("Problems with field " + fieldType + " parsing default date-string '" + defaultStr + "' using '" + formatConfig + "'", e);
        }
    }

    public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        String dateStr = results.getString(columnPos);
        if (dateStr == null) {
            return null;
        }
        BaseDateType.DateStringFormatConfig formatConfig = DateStringType.convertDateStringConfig(fieldType);
        try {
            return DateStringType.parseDateString(formatConfig, dateStr);
        }
        catch (ParseException e) {
            throw SqlExceptionUtil.create("Problems with column " + columnPos + " parsing date-string '" + dateStr + "' using '" + formatConfig + "'", e);
        }
    }

    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        Date date = (Date)obj;
        return DateStringType.formatDate(DateStringType.convertDateStringConfig(fieldType), date);
    }

    public boolean isValidForField(Field field) {
        return true;
    }

    public Object makeConfigObject(FieldType fieldType) {
        String format = fieldType.getFormat();
        if (format == null) {
            return defaultDateFormatConfig;
        }
        return new BaseDateType.DateStringFormatConfig(format);
    }

    public int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }
}

