/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseEnumType;
import com.j256.ormlite.support.DatabaseResults;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class EnumStringType
extends BaseEnumType {
    public static int DEFAULT_WIDTH = 100;
    private static final EnumStringType singleTon = new EnumStringType();

    public static EnumStringType getSingleton() {
        return singleTon;
    }

    private EnumStringType() {
        super(SqlType.STRING, new Class[]{Enum.class});
    }

    public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        String val = results.getString(columnPos);
        if (fieldType == null) {
            return val;
        }
        if (val == null) {
            return null;
        }
        Map enumStringMap = (Map)fieldType.getDataTypeConfigObj();
        if (enumStringMap == null) {
            return EnumStringType.enumVal(fieldType, val, null, fieldType.getUnknownEnumVal());
        }
        return EnumStringType.enumVal(fieldType, val, (Enum)enumStringMap.get(val), fieldType.getUnknownEnumVal());
    }

    public Object parseDefaultString(FieldType fieldType, String defaultStr) {
        return defaultStr;
    }

    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        Enum enumVal = (Enum)obj;
        return enumVal.name();
    }

    public Object makeConfigObject(FieldType fieldType) throws SQLException {
        HashMap<String, Enum> enumStringMap = new HashMap<String, Enum>();
        Enum[] constants = (Enum[])fieldType.getFieldType().getEnumConstants();
        if (constants == null) {
            throw new SQLException("Field " + fieldType + " improperly configured as type " + this);
        }
        for (Enum enumVal : constants) {
            enumStringMap.put(enumVal.name(), enumVal);
        }
        return enumStringMap;
    }

    public int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }
}

