/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDataType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.DatabaseResults;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Arrays;

public class SerializableType
extends BaseDataType {
    private static final SerializableType singleTon = new SerializableType();

    public static SerializableType getSingleton() {
        return singleTon;
    }

    private SerializableType() {
        super(SqlType.SERIALIZABLE, new Class[0]);
    }

    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        throw new SQLException("Default values for serializable types are not supported");
    }

    public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        byte[] bytes = results.getBytes(columnPos);
        if (bytes == null) {
            return null;
        }
        try {
            ObjectInputStream objInStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
            return objInStream.readObject();
        }
        catch (Exception e) {
            throw SqlExceptionUtil.create("Could not read serialized object from byte array: " + Arrays.toString(bytes) + "(len " + bytes.length + ")", e);
        }
    }

    public Object javaToSqlArg(FieldType fieldType, Object obj) throws SQLException {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            ObjectOutputStream objOutStream = new ObjectOutputStream(outStream);
            objOutStream.writeObject(obj);
            return outStream.toByteArray();
        }
        catch (Exception e) {
            throw SqlExceptionUtil.create("Could not write serialized object to byte array: " + obj, e);
        }
    }

    public boolean isValidForField(Field field) {
        return Serializable.class.isAssignableFrom(field.getType());
    }

    public boolean isStreamType() {
        return true;
    }

    public boolean isComparable() {
        return false;
    }

    public boolean isAppropriateId() {
        return false;
    }

    public boolean isSelectArgRequired() {
        return true;
    }
}

