/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDataType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.DatabaseResults;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.sql.SQLException;

public class StringBytesType
extends BaseDataType {
    private static final String DEFAULT_STRING_BYTES_CHARSET_NAME = "Unicode";
    private static final StringBytesType singleTon = new StringBytesType();

    public static StringBytesType getSingleton() {
        return singleTon;
    }

    private StringBytesType() {
        super(SqlType.BYTE_ARRAY, new Class[0]);
    }

    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        throw new SQLException("String bytes type cannot have default values");
    }

    public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        byte[] bytes = results.getBytes(columnPos);
        if (bytes == null) {
            return null;
        }
        String charsetName = this.getCharsetName(fieldType);
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw SqlExceptionUtil.create("Could not convert string with charset name: " + charsetName, e);
        }
    }

    public Object javaToSqlArg(FieldType fieldType, Object javaObject) throws SQLException {
        String string = (String)javaObject;
        String charsetName = this.getCharsetName(fieldType);
        try {
            return string.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw SqlExceptionUtil.create("Could not convert string with charset name: " + charsetName, e);
        }
    }

    public boolean isValidForField(Field field) {
        return true;
    }

    public boolean isAppropriateId() {
        return false;
    }

    public boolean isSelectArgRequired() {
        return true;
    }

    private String getCharsetName(FieldType fieldType) {
        if (fieldType == null || fieldType.getFormat() == null) {
            return DEFAULT_STRING_BYTES_CHARSET_NAME;
        }
        return fieldType.getFormat();
    }
}

