/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDataType;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.DatabaseResults;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.UUID;

public class UuidType
extends BaseDataType {
    public static int DEFAULT_WIDTH = 48;
    private static final UuidType singleTon = new UuidType();

    public static UuidType getSingleton() {
        return singleTon;
    }

    private UuidType() {
        super(SqlType.STRING, new Class[]{UUID.class});
    }

    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        try {
            return UUID.fromString(defaultStr);
        }
        catch (IllegalArgumentException e) {
            throw SqlExceptionUtil.create("Problems with field " + fieldType + " parsing default UUID-string '" + defaultStr + "'", e);
        }
    }

    public Object resultToJava(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        String uuidStr = results.getString(columnPos);
        if (uuidStr == null) {
            return null;
        }
        try {
            return UUID.fromString(uuidStr);
        }
        catch (IllegalArgumentException e) {
            throw SqlExceptionUtil.create("Problems with column " + columnPos + " parsing UUID-string '" + uuidStr + "'", e);
        }
    }

    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        UUID uuid = (UUID)obj;
        return uuid.toString();
    }

    public boolean isValidForField(Field field) {
        return true;
    }

    public boolean isValidGeneratedType() {
        return true;
    }

    public boolean isSelfGeneratedId() {
        return true;
    }

    public Object generatedId() {
        return UUID.randomUUID();
    }

    public int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }
}

