/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.Log;
import com.j256.ormlite.logger.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LocalLog
implements Log {
    public static final String LOCAL_LOG_LEVEL_PROPERTY = "com.j256.ormlite.logger.level";
    public static final String LOCAL_LOG_FILE_PROPERTY = "com.j256.ormlite.logger.file";
    private static final Log.Level DEFAULT_LEVEL = Log.Level.DEBUG;
    private static ThreadLocal<DateFormat> dateFormatThreadLocal = new ThreadLocal();
    private final String className;
    private final Log.Level level;
    private final PrintStream printStream;

    public LocalLog(String className) {
        this.className = LoggerFactory.getSimpleClassName(className);
        String levelName = System.getProperty(LOCAL_LOG_LEVEL_PROPERTY);
        if (levelName == null) {
            this.level = DEFAULT_LEVEL;
        } else {
            Log.Level matchedLevel;
            try {
                matchedLevel = Log.Level.valueOf(levelName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Level '" + levelName + "' was not found", e);
            }
            this.level = matchedLevel;
        }
        String logPath = System.getProperty(LOCAL_LOG_FILE_PROPERTY);
        if (logPath == null) {
            this.printStream = System.out;
        } else {
            try {
                this.printStream = new PrintStream(new File(logPath));
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Log file " + logPath + " was not found", e);
            }
        }
    }

    public boolean isLevelEnabled(Log.Level level) {
        return this.level.isEnabled(level);
    }

    public void log(Log.Level level, String msg) {
        this.printMessage(level, msg, null);
    }

    public void log(Log.Level level, String msg, Throwable throwable) {
        this.printMessage(level, msg, throwable);
    }

    void flush() {
        this.printStream.flush();
    }

    private void printMessage(Log.Level level, String message, Throwable throwable) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        StringBuilder sb = new StringBuilder(128);
        DateFormat dateFormat = dateFormatThreadLocal.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
            dateFormatThreadLocal.set(dateFormat);
        }
        sb.append(dateFormat.format(new Date()));
        sb.append(" [").append(level.name()).append("] ");
        sb.append(this.className).append(' ');
        sb.append(message);
        this.printStream.println(sb.toString());
        if (throwable != null) {
            throwable.printStackTrace(this.printStream);
        }
    }
}

