/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.Log;
import java.util.Arrays;

public class Logger {
    private static final String ARG_STRING = "{}";
    private static final int ARG_STRING_LENGTH = "{}".length();
    private final Log log;

    public Logger(Log log) {
        this.log = log;
    }

    public boolean isLevelEnabled(Log.Level level) {
        return this.log.isLevelEnabled(level);
    }

    public void trace(String msg, Object ... args) {
        this.log(Log.Level.TRACE, null, msg, args);
    }

    public void trace(Throwable throwable, String msg, Object ... args) {
        this.log(Log.Level.TRACE, throwable, msg, args);
    }

    public void debug(String msg, Object ... args) {
        this.log(Log.Level.DEBUG, null, msg, args);
    }

    public void debug(Throwable throwable, String msg, Object ... args) {
        this.log(Log.Level.DEBUG, throwable, msg, args);
    }

    public void info(String msg, Object ... args) {
        this.log(Log.Level.INFO, null, msg, args);
    }

    public void info(Throwable throwable, String msg, Object ... args) {
        this.log(Log.Level.INFO, throwable, msg, args);
    }

    public void warn(String msg, Object ... args) {
        this.log(Log.Level.WARNING, null, msg, args);
    }

    public void warn(Throwable throwable, String msg, Object ... args) {
        this.log(Log.Level.WARNING, throwable, msg, args);
    }

    public void error(String msg, Object ... args) {
        this.log(Log.Level.ERROR, null, msg, args);
    }

    public void error(Throwable throwable, String msg, Object ... args) {
        this.log(Log.Level.ERROR, throwable, msg, args);
    }

    public void fatal(String msg, Object ... args) {
        this.log(Log.Level.FATAL, null, msg, args);
    }

    public void fatal(Throwable throwable, String msg, Object ... args) {
        this.log(Log.Level.FATAL, throwable, msg, args);
    }

    private void log(Log.Level level, Throwable throwable, String msg, Object[] args) {
        if (this.log.isLevelEnabled(level)) {
            String fullMsg = this.buildFullMessage(msg, args);
            if (throwable == null) {
                this.log.log(level, fullMsg);
            } else {
                this.log.log(level, fullMsg, throwable);
            }
        }
    }

    private String buildFullMessage(String msg, Object[] args) {
        int argIndex;
        StringBuilder sb = new StringBuilder(128);
        int lastIndex = 0;
        int argC = 0;
        while ((argIndex = msg.indexOf(ARG_STRING, lastIndex)) != -1) {
            sb.append(msg.substring(lastIndex, argIndex));
            lastIndex = argIndex + ARG_STRING_LENGTH;
            if (argC >= args.length) continue;
            Object arg = args[argC];
            if (arg != null && arg.getClass().isArray()) {
                sb.append(Arrays.toString((Object[])arg));
            } else {
                sb.append(arg);
            }
            ++argC;
        }
        sb.append(msg.substring(lastIndex));
        return sb.toString();
    }
}

