/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.misc;

import com.j256.ormlite.dao.Dao;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDaoEnabled<T, ID> {
    protected transient Dao<T, ID> dao;

    public int create() throws SQLException {
        this.checkForDao();
        BaseDaoEnabled t = this;
        return this.dao.create(t);
    }

    public int refresh() throws SQLException {
        this.checkForDao();
        BaseDaoEnabled t = this;
        return this.dao.refresh(t);
    }

    public int update() throws SQLException {
        this.checkForDao();
        BaseDaoEnabled t = this;
        return this.dao.update(t);
    }

    public int updateId(ID newId) throws SQLException {
        this.checkForDao();
        BaseDaoEnabled t = this;
        return this.dao.updateId(t, newId);
    }

    public int delete() throws SQLException {
        this.checkForDao();
        BaseDaoEnabled t = this;
        return this.dao.delete(t);
    }

    public String objectToString() {
        try {
            this.checkForDao();
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e);
        }
        BaseDaoEnabled t = this;
        return this.dao.objectToString(t);
    }

    public ID extractId() throws SQLException {
        this.checkForDao();
        BaseDaoEnabled t = this;
        return this.dao.extractId(t);
    }

    public boolean objectsEqual(T other) throws SQLException {
        this.checkForDao();
        BaseDaoEnabled t = this;
        return this.dao.objectsEqual(t, (BaseDaoEnabled)other);
    }

    public void setDao(Dao<T, ID> dao) {
        this.dao = dao;
    }

    private void checkForDao() throws SQLException {
        if (this.dao == null) {
            throw new SQLException("Dao has not been set on " + this.getClass() + " object: " + this);
        }
    }
}

