/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseResults;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectIterator<T, ID>
implements CloseableIterator<T> {
    private static final Logger logger = LoggerFactory.getLogger(SelectIterator.class);
    private final Class<?> dataClass;
    private final Dao<T, ID> classDao;
    private final ConnectionSource connectionSource;
    private final DatabaseConnection connection;
    private final CompiledStatement compiledStmt;
    private final DatabaseResults results;
    private final GenericRowMapper<T> rowMapper;
    private final String statement;
    private boolean closed = false;
    private T last = null;
    private int rowC = 0;

    public SelectIterator(Class<?> dataClass, Dao<T, ID> classDao, GenericRowMapper<T> rowMapper, ConnectionSource connectionSource, DatabaseConnection connection, CompiledStatement compiledStmt, String statement) throws SQLException {
        this.dataClass = dataClass;
        this.classDao = classDao;
        this.rowMapper = rowMapper;
        this.connectionSource = connectionSource;
        this.connection = connection;
        this.compiledStmt = compiledStmt;
        this.results = compiledStmt.runQuery();
        this.statement = statement;
        if (statement != null) {
            logger.debug("starting iterator @{} for '{}'", this.hashCode(), statement);
        }
    }

    public boolean hasNextThrow() throws SQLException {
        if (this.closed) {
            return false;
        }
        if (this.results.next()) {
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.hasNextThrow();
        }
        catch (SQLException e) {
            this.last = null;
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new IllegalStateException("Errors getting more results of " + this.dataClass, e);
        }
    }

    public T nextThrow() throws SQLException {
        if (this.closed) {
            return null;
        }
        this.last = this.rowMapper.mapRow(this.results);
        ++this.rowC;
        return this.last;
    }

    @Override
    public T next() {
        try {
            return this.nextThrow();
        }
        catch (SQLException e) {
            this.last = null;
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new IllegalStateException("Errors getting more results of " + this.dataClass, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThrow() throws SQLException {
        if (this.last == null) {
            throw new IllegalStateException("No last " + this.dataClass + " object to remove. Must be called after a call to next.");
        }
        if (this.classDao == null) {
            throw new IllegalStateException("Cannot remove " + this.dataClass + " object because classDao not initialized");
        }
        try {
            this.classDao.delete(this.last);
        }
        finally {
            this.last = null;
        }
    }

    @Override
    public void remove() {
        try {
            this.removeThrow();
        }
        catch (SQLException e) {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new IllegalStateException("Errors trying to delete " + this.dataClass + " object " + this.last, e);
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.compiledStmt.close();
            this.closed = true;
            this.last = null;
            if (this.statement != null) {
                logger.debug("closed iterator @{} after {} rows", this.hashCode(), this.rowC);
            }
            this.connectionSource.releaseConnection(this.connection);
        }
    }

    public DatabaseResults getRawResults() {
        return this.results;
    }
}

