/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.dao.BaseForeignCollection;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.GenericRowMapper;
import com.j256.ormlite.stmt.mapped.BaseMappedStatement;
import com.j256.ormlite.support.DatabaseResults;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMappedQuery<T, ID>
extends BaseMappedStatement<T, ID>
implements GenericRowMapper<T> {
    protected final FieldType[] resultsFieldTypes;
    private Map<String, Integer> columnPositions = null;
    private Object parent = null;

    protected BaseMappedQuery(TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes, FieldType[] resultsFieldTypes) {
        super(tableInfo, statement, argFieldTypes);
        this.resultsFieldTypes = resultsFieldTypes;
    }

    @Override
    public T mapRow(DatabaseResults results) throws SQLException {
        Map<String, Integer> colPosMap = this.columnPositions == null ? new HashMap<String, Integer>() : this.columnPositions;
        Object instance = this.tableInfo.createObject();
        Object id = null;
        boolean foreignCollections = false;
        for (FieldType fieldType : this.resultsFieldTypes) {
            if (fieldType.isForeignCollection()) {
                foreignCollections = true;
                continue;
            }
            Object val = fieldType.resultToJava(results, colPosMap);
            if (this.parent != null && fieldType.getField().getType() == this.parent.getClass()) {
                fieldType.assignField(instance, this.parent, true);
            } else {
                fieldType.assignField(instance, val, false);
            }
            if (fieldType != this.idField) continue;
            id = val;
        }
        if (foreignCollections) {
            for (FieldType fieldType : this.resultsFieldTypes) {
                BaseForeignCollection collection;
                if (!fieldType.isForeignCollection() || (collection = fieldType.buildForeignCollection(instance, id, false)) == null) continue;
                fieldType.assignField(instance, collection, false);
            }
        }
        if (this.columnPositions == null) {
            this.columnPositions = colPosMap;
        }
        return instance;
    }

    public FieldType[] getResultsFieldTypes() {
        return this.resultsFieldTypes;
    }

    public void setParentObject(Object parent) {
        this.parent = parent;
    }
}

