/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMappedStatement<T, ID> {
    protected static Logger logger = LoggerFactory.getLogger(BaseMappedStatement.class);
    protected final TableInfo<T, ID> tableInfo;
    protected final FieldType idField;
    protected final String statement;
    protected final FieldType[] argFieldTypes;

    protected BaseMappedStatement(TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes) {
        this.tableInfo = tableInfo;
        this.idField = tableInfo.getIdField();
        this.statement = statement;
        this.argFieldTypes = argFieldTypes;
    }

    public int update(DatabaseConnection databaseConnection, T data) throws SQLException {
        try {
            Object[] args = this.getFieldObjects(data);
            int rowC = databaseConnection.update(this.statement, args, this.argFieldTypes);
            logger.debug("update data with statement '{}' and {} args, changed {} rows", this.statement, args.length, rowC);
            if (args.length > 0) {
                logger.trace("update arguments: {}", new Object[]{args});
            }
            return rowC;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Unable to run update stmt on object " + data + ": " + this.statement, e);
        }
    }

    public int delete(DatabaseConnection databaseConnection, T data) throws SQLException {
        try {
            Object[] args = this.getFieldObjects(data);
            int rowC = databaseConnection.delete(this.statement, args, this.argFieldTypes);
            logger.debug("delete data with statement '{}' and {} args, changed {} rows", this.statement, args.length, rowC);
            if (args.length > 0) {
                logger.trace("delete arguments: {}", new Object[]{args});
            }
            return rowC;
        }
        catch (SQLException e) {
            throw SqlExceptionUtil.create("Unable to run delete stmt on object " + data + ": " + this.statement, e);
        }
    }

    public String getStatement() {
        return this.statement;
    }

    protected Object[] getFieldObjects(Object data) throws SQLException {
        Object[] objects = new Object[this.argFieldTypes.length];
        for (int i = 0; i < this.argFieldTypes.length; ++i) {
            FieldType fieldType = this.argFieldTypes[i];
            objects[i] = fieldType.extractJavaFieldToSqlArgValue(data);
            if (objects[i] != null || fieldType.getDefaultValue() == null) continue;
            objects[i] = fieldType.getDefaultValue();
        }
        return objects;
    }

    protected Object convertIdToFieldObject(ID id) throws SQLException {
        return this.idField.convertJavaFieldToSqlArgValue(id);
    }

    protected Object extractIdToFieldObject(T data) throws SQLException {
        return this.idField.extractJavaFieldToSqlArgValue(data);
    }

    static void appendWhereId(DatabaseType databaseType, FieldType idField, StringBuilder sb, List<FieldType> fieldTypeList) {
        sb.append("WHERE ");
        BaseMappedStatement.appendFieldColumnName(databaseType, sb, idField, fieldTypeList);
        sb.append("= ?");
    }

    static void appendTableName(DatabaseType databaseType, StringBuilder sb, String prefix, String tableName) {
        if (prefix != null) {
            sb.append(prefix);
        }
        databaseType.appendEscapedEntityName(sb, tableName);
        sb.append(' ');
    }

    static void appendFieldColumnName(DatabaseType databaseType, StringBuilder sb, FieldType fieldType, List<FieldType> fieldTypeList) {
        databaseType.appendEscapedEntityName(sb, fieldType.getDbColumnName());
        if (fieldTypeList != null) {
            fieldTypeList.add(fieldType);
        }
        sb.append(' ');
    }

    public String toString() {
        return "MappedStatement: " + this.statement;
    }
}

