/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.logger.Log;
import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.mapped.BaseMappedQuery;
import com.j256.ormlite.support.CompiledStatement;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedPreparedStmt<T, ID>
extends BaseMappedQuery<T, ID>
implements PreparedQuery<T>,
PreparedDelete<T>,
PreparedUpdate<T> {
    private final ArgumentHolder[] argHolders;
    private final Integer limit;
    private final StatementBuilder.StatementType type;

    public MappedPreparedStmt(TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes, FieldType[] resultFieldTypes, ArgumentHolder[] argHolders, Integer limit, StatementBuilder.StatementType type) {
        super(tableInfo, statement, argFieldTypes, resultFieldTypes);
        this.argHolders = argHolders;
        this.limit = limit;
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompiledStatement compile(DatabaseConnection databaseConnection) throws SQLException {
        CompiledStatement stmt = databaseConnection.compileStatement(this.statement, this.type, this.argFieldTypes);
        boolean ok = false;
        try {
            if (this.limit != null) {
                stmt.setMaxRows(this.limit);
            }
            Object[] argValues = null;
            if (logger.isLevelEnabled(Log.Level.TRACE) && this.argHolders.length > 0) {
                argValues = new Object[this.argHolders.length];
            }
            for (int i = 0; i < this.argHolders.length; ++i) {
                Object argValue = this.argHolders[i].getSqlArgValue();
                FieldType fieldType = this.argFieldTypes[i];
                SqlType sqlType = fieldType == null ? this.argHolders[i].getSqlType() : fieldType.getSqlType();
                if (argValue == null) {
                    stmt.setNull(i, sqlType);
                } else {
                    stmt.setObject(i, argValue, sqlType);
                }
                if (argValues == null) continue;
                argValues[i] = argValue;
            }
            logger.debug("prepared statement '{}' with {} args", this.statement, this.argHolders.length);
            if (argValues != null) {
                logger.trace("prepared statement arguments: {}", new Object[]{argValues});
            }
            ok = true;
            CompiledStatement compiledStatement = stmt;
            return compiledStatement;
        }
        finally {
            if (!ok) {
                stmt.close();
            }
        }
    }
}

