/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt.mapped;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.mapped.BaseMappedStatement;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedUpdate<T, ID>
extends BaseMappedStatement<T, ID> {
    private MappedUpdate(TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes) {
        super(tableInfo, statement, argFieldTypes);
    }

    public static <T, ID> MappedUpdate<T, ID> build(DatabaseType databaseType, TableInfo<T, ID> tableInfo) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot update " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        if (tableInfo.getFieldTypes().length == 1) {
            throw new SQLException("Cannot update " + tableInfo.getDataClass() + " with only the id field.  You should use updateId().");
        }
        StringBuilder sb = new StringBuilder(64);
        MappedUpdate.appendTableName(databaseType, sb, "UPDATE ", tableInfo.getTableName());
        boolean first = true;
        int argFieldC = 0;
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            if (!MappedUpdate.isFieldUpdatable(fieldType, idField)) continue;
            ++argFieldC;
        }
        FieldType[] argFieldTypes = new FieldType[++argFieldC];
        argFieldC = 0;
        for (FieldType fieldType : tableInfo.getFieldTypes()) {
            if (!MappedUpdate.isFieldUpdatable(fieldType, idField)) continue;
            if (first) {
                sb.append("SET ");
                first = false;
            } else {
                sb.append(", ");
            }
            MappedUpdate.appendFieldColumnName(databaseType, sb, fieldType, null);
            argFieldTypes[argFieldC++] = fieldType;
            sb.append("= ?");
        }
        sb.append(' ');
        MappedUpdate.appendWhereId(databaseType, idField, sb, null);
        argFieldTypes[argFieldC++] = idField;
        return new MappedUpdate<T, ID>(tableInfo, sb.toString(), argFieldTypes);
    }

    private static boolean isFieldUpdatable(FieldType fieldType, FieldType idField) {
        return fieldType != idField && !fieldType.isForeignCollection();
    }
}

