/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.table;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.misc.BaseDaoEnabled;
import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableInfo<T, ID> {
    private final Dao<T, ID> dao;
    private final Class<T> dataClass;
    private final String tableName;
    private final FieldType[] fieldTypes;
    private final FieldType idField;
    private final Constructor<T> constructor;
    private Map<String, FieldType> fieldNameMap;

    public TableInfo(ConnectionSource connectionSource, Dao<T, ID> dao, Class<T> dataClass) throws SQLException {
        this(connectionSource.getDatabaseType(), dao, DatabaseTableConfig.fromClass(connectionSource, dataClass));
    }

    public TableInfo(DatabaseType databaseType, Dao<T, ID> dao, DatabaseTableConfig<T> tableConfig) throws SQLException {
        this.dao = dao;
        this.dataClass = tableConfig.getDataClass();
        this.tableName = tableConfig.getTableName();
        this.fieldTypes = tableConfig.getFieldTypes(databaseType);
        FieldType findIdFieldType = null;
        for (FieldType fieldType : this.fieldTypes) {
            if (!fieldType.isId() && !fieldType.isGeneratedId() && !fieldType.isGeneratedIdSequence()) continue;
            if (findIdFieldType != null) {
                throw new SQLException("More than 1 idField configured for class " + this.dataClass + " (" + findIdFieldType + "," + fieldType + ")");
            }
            findIdFieldType = fieldType;
        }
        if (this.fieldTypes.length == 1 && findIdFieldType != null && findIdFieldType.isGeneratedId()) {
            throw new SQLException("Must have more than a single field which is a generated-id for class " + this.dataClass);
        }
        this.idField = findIdFieldType;
        this.constructor = tableConfig.getConstructor();
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public FieldType[] getFieldTypes() {
        return this.fieldTypes;
    }

    public FieldType getFieldTypeByColumnName(String columnName) {
        FieldType fieldType;
        if (this.fieldNameMap == null) {
            HashMap<String, FieldType> map = new HashMap<String, FieldType>();
            for (FieldType fieldType2 : this.fieldTypes) {
                map.put(fieldType2.getDbColumnName(), fieldType2);
            }
            this.fieldNameMap = map;
        }
        if ((fieldType = this.fieldNameMap.get(columnName)) == null) {
            for (FieldType fieldType2 : this.fieldTypes) {
                if (!fieldType2.getFieldName().equals(columnName)) continue;
                throw new IllegalArgumentException("You should use columnName '" + fieldType2.getDbColumnName() + "' for table " + this.tableName + " instead of fieldName '" + columnName + "'");
            }
            throw new IllegalArgumentException("Unknown column name '" + columnName + "' in table " + this.tableName);
        }
        return fieldType;
    }

    public FieldType getIdField() {
        return this.idField;
    }

    public Constructor<T> getConstructor() {
        return this.constructor;
    }

    public String objectToString(T object) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(object.getClass().getSimpleName());
        for (FieldType fieldType : this.fieldTypes) {
            sb.append(' ').append(fieldType.getDbColumnName()).append("=");
            try {
                sb.append(fieldType.extractJavaFieldValue(object));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not generate toString of field " + fieldType, e);
            }
        }
        return sb.toString();
    }

    public T createObject() throws SQLException {
        return TableInfo.createObject(this.constructor, this.dao);
    }

    public static <T, ID> T createObject(Constructor<?> constructor, Dao<T, ID> dao) throws SQLException {
        boolean accessible = constructor.isAccessible();
        try {
            Object instance;
            if (!accessible) {
                constructor.setAccessible(true);
            }
            if ((instance = constructor.newInstance(new Object[0])) instanceof BaseDaoEnabled) {
                BaseDaoEnabled daoEnabled = (BaseDaoEnabled)instance;
                daoEnabled.setDao(dao);
            }
            Object obj = instance;
            return (T)obj;
        }
        catch (Exception e) {
            throw SqlExceptionUtil.create("Could not create object for " + constructor.getDeclaringClass(), e);
        }
        finally {
            if (!accessible) {
                constructor.setAccessible(false);
            }
        }
    }

    public boolean isUpdatable() {
        return this.idField != null && this.fieldTypes.length > 1;
    }
}

