/*
 * Decompiled with CFR 0.152.
 */
package com.flattr4android.rest;

import com.flattr4android.rest.AuthenticationException;
import com.flattr4android.rest.Category;
import com.flattr4android.rest.FlattrRestException;
import com.flattr4android.rest.FlattrServerResponseException;
import com.flattr4android.rest.Language;
import com.flattr4android.rest.Thing;
import com.flattr4android.rest.User;
import com.flattr4android.rest.demo.SampleThing;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import org.xml.sax.SAXException;

public class FlattrRestClient {
    public static final String DEMO_SAMPLE_THING_ID = "demo_thing";
    private OAuthConsumer consumer;
    private boolean demoMode = false;
    private Thing demoSampleThing;

    public FlattrRestClient(OAuthConsumer consumer) {
        this.consumer = consumer;
    }

    public FlattrRestClient(String consumerKey, String consumerSecret, String accessToken, String tokenSecret) {
        this.consumer = new DefaultOAuthConsumer(consumerKey, consumerSecret);
        this.consumer.setTokenWithSecret(accessToken, tokenSecret);
    }

    public boolean isDemoMode() {
        return this.demoMode;
    }

    public void setDemoMode(boolean demoMode) {
        this.demoMode = demoMode;
    }

    public User getMe() throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, ParserConfigurationException, SAXException, IOException, FlattrRestException {
        return User.buildUser(this, this.getResourceInputStream("/rest/0.0.1/user/me"));
    }

    public User getUser(int id) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, ParserConfigurationException, SAXException, IOException, FlattrRestException {
        return User.buildUser(this, this.getResourceInputStream("/rest/0.0.1/user/get/id/" + id));
    }

    public User getUser(String userName) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, ParserConfigurationException, SAXException, IOException, FlattrRestException {
        return User.buildUser(this, this.getResourceInputStream("/rest/0.0.1/user/get/name/" + userName));
    }

    public Thing getThing(String id) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, FlattrRestException, IOException {
        if (this.isDemoMode() && id.equals(DEMO_SAMPLE_THING_ID)) {
            if (this.demoSampleThing == null) {
                this.demoSampleThing = new SampleThing();
            }
            return this.demoSampleThing;
        }
        return Thing.buildOneThing(this, this.getResourceInputStream("/rest/0.0.1/thing/get/id/" + id));
    }

    public void setDemoSampleThing(Thing model) {
        this.demoSampleThing = new SampleThing(model);
    }

    public ArrayList<Thing> getUserThings(int userId) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, FlattrRestException, IOException {
        return Thing.buildThings(this, this.getResourceInputStream("/rest/0.0.1/thing/listbyuser/id/" + userId));
    }

    public void clickThing(String id) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, ParserConfigurationException, SAXException, IOException, FlattrServerResponseException {
        if (!this.isDemoMode()) {
            this.sendRequest("/rest/0.0.1/thing/click/id/" + id);
        }
    }

    public void register(Thing thing) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, FlattrServerResponseException, IOException {
        String content = "<thing><url>" + thing.getURL() + "</url>" + "<title><![CDATA[" + thing.getTitle() + "]]></title>" + "<category>" + thing.getCategoryName() + "</category>" + "<description><![CDATA[" + thing.getDescription() + "]]></description>" + "<language>" + thing.getLanguage() + "</language>" + "<hidden>1</hidden>" + "<tags>";
        for (String tag : thing.getTags()) {
            content = String.valueOf(content) + "<tag>" + tag + "</tag>";
        }
        content = String.valueOf(content) + "</tags></thing>";
        this.sendRequest("/rest/0.0.1/thing/register", "POST", content);
    }

    public ArrayList<Language> getLanguages() throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, FlattrServerResponseException, FlattrRestException, IOException {
        return Language.buildLanguages(this.getResourceInputStream("/rest/0.0.1/feed/languages"));
    }

    public ArrayList<Category> getCategories() throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, FlattrServerResponseException, FlattrRestException, IOException {
        return Category.buildCategories(this.getResourceInputStream("/rest/0.0.1/feed/categories"));
    }

    private HttpURLConnection sendRequest(String uri) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, FlattrServerResponseException, IOException {
        return this.sendRequest(uri, "GET", null);
    }

    private HttpURLConnection sendRequest(String uri, String method, String content) throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, IOException, FlattrServerResponseException {
        int reqCode;
        URL url = new URL("http://api.flattr.com" + uri);
        HttpURLConnection request = (HttpURLConnection)url.openConnection();
        this.consumer.sign((Object)request);
        request.setRequestMethod(method);
        if (content != null) {
            request.setDoOutput(true);
            PrintWriter pw = new PrintWriter(request.getOutputStream());
            pw.write(content);
        }
        request.connect();
        try {
            reqCode = request.getResponseCode();
        }
        catch (IOException e) {
            if (e.getMessage().equals("Received authentication challenge is null")) {
                throw new AuthenticationException(request);
            }
            throw e;
        }
        if (reqCode != 200) {
            if (reqCode == 401) {
                throw new AuthenticationException(request);
            }
            throw new FlattrServerResponseException(request);
        }
        return request;
    }

    private InputStream getResourceInputStream(String uri) throws IOException, OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, FlattrServerResponseException {
        return (InputStream)this.sendRequest(uri).getContent();
    }
}

