/*
 * Decompiled with CFR 0.152.
 */
package com.flattr4android.rest;

import com.flattr4android.rest.FlattrRestClient;
import com.flattr4android.rest.FlattrRestException;
import com.flattr4android.rest.FlattrServerResponseException;
import com.flattr4android.rest.ThingSAXHandler;
import com.flattr4android.rest.User;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Thing {
    public static final String STATUS_OK = "ok";
    public static final String STATUS_OWNER = "owner";
    public static final String STATUS_INACTIVE = "inactive";
    public static final String STATUS_CLICKED = "clicked";
    public static final int INT_STATUS_UNKNOWN = 1;
    public static final int INT_STATUS_OK = 2;
    public static final int INT_STATUS_OWNER = 3;
    public static final int INT_STATUS_INACTIVE = 4;
    public static final int INT_STATUS_CLICKED = 5;
    protected String id;
    protected Date created;
    protected String language;
    protected String url;
    protected String title;
    protected String description;
    protected int clicks;
    protected int userId;
    protected String userName;
    protected List<String> tags = new ArrayList<String>();
    protected String categoryId;
    protected String categoryName;
    protected String status;
    protected User user;
    private boolean clicked = false;
    FlattrRestClient fr;

    public Thing(FlattrRestClient fr) {
        this.fr = fr;
    }

    public Thing() {
    }

    public String getId() {
        return this.id;
    }

    public Date getCreationDate() {
        return this.created;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getClicks() {
        return this.clicks;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public User getUser() throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, ParserConfigurationException, SAXException, IOException, FlattrRestException {
        if (this.user == null) {
            this.user = this.fr.getUser(this.getUserId());
        }
        return this.user;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void addTag(String tag) {
        this.tags.add(tag);
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String category) {
        this.categoryName = category;
    }

    public String getStatus() {
        if (this.fr != null && this.fr.isDemoMode() && !this.clicked) {
            return STATUS_OK;
        }
        return this.status;
    }

    public int getIntStatus() {
        String st = this.getStatus();
        if (st.equals(STATUS_OK)) {
            return 2;
        }
        if (st.equals(STATUS_CLICKED)) {
            return 5;
        }
        if (st.equals(STATUS_OWNER)) {
            return 3;
        }
        if (st.equals(STATUS_INACTIVE)) {
            return 4;
        }
        return 1;
    }

    public String getFlattrURL() {
        return "https://flattr.com/thing/" + this.getId();
    }

    public String toString() {
        return String.valueOf(this.getTitle()) + " - by " + this.getUserName();
    }

    public void click() throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, FlattrServerResponseException, ParserConfigurationException, SAXException, IOException {
        this.fr.clickThing(this.getId());
        this.updateAfterClick();
    }

    protected void updateAfterClick() {
        this.status = STATUS_CLICKED;
        ++this.clicks;
        this.clicked = true;
    }

    public static ArrayList<Thing> buildThings(FlattrRestClient fr, InputStream xmlDescription) throws FlattrRestException {
        ArrayList<Thing> al = new ArrayList<Thing>();
        try {
            XMLReader parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            parser.setContentHandler(new ThingSAXHandler(fr, al));
            parser.parse(new InputSource(xmlDescription));
        }
        catch (Exception e) {
            throw new FlattrRestException(e);
        }
        return al;
    }

    public static Thing buildOneThing(FlattrRestClient fr, InputStream is) throws FlattrRestException {
        ArrayList<Thing> al = Thing.buildThings(fr, is);
        if (al.size() != 1) {
            throw new FlattrRestException("Unexpected amount of things in the stream: " + al.size());
        }
        return al.get(0);
    }

    public static String extractThingIDFromQRCode(String qrCodeInfo) {
        int slashIdx = qrCodeInfo.lastIndexOf("/");
        if (slashIdx == qrCodeInfo.length() - 1) {
            qrCodeInfo = qrCodeInfo.substring(0, slashIdx);
            slashIdx = qrCodeInfo.lastIndexOf("/");
        }
        if (slashIdx < 0) {
            return null;
        }
        return qrCodeInfo.substring(qrCodeInfo.lastIndexOf("/") + 1);
    }
}

