/*
 * Decompiled with CFR 0.152.
 */
package com.flattr4android.rest;

import com.flattr4android.rest.FlattrRestClient;
import com.flattr4android.rest.PortableSAXHandler;
import com.flattr4android.rest.Thing;
import java.util.ArrayList;
import java.util.Date;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class ThingSAXHandler
extends PortableSAXHandler {
    private boolean inUser = false;
    private boolean inCategory = false;
    private StringBuilder currentValue = new StringBuilder();
    private FlattrRestClient fr;
    private ArrayList<Thing> thingList;
    private Thing currentThing = null;

    public ThingSAXHandler(FlattrRestClient fr, ArrayList<Thing> thingList) {
        this.thingList = thingList;
        this.fr = fr;
    }

    @Override
    public void startElement(String nsURI, String localName, String qName, Attributes attributes) throws SAXException {
        String tagName = this.getTagName(localName, qName);
        this.currentValue = new StringBuilder();
        if (tagName.equals("thing")) {
            this.currentThing = new Thing(this.fr);
        } else if (tagName.equals("user")) {
            this.inUser = true;
        } else if (tagName.equals("category")) {
            this.inCategory = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String tagName = this.getTagName(localName, qName);
        String value = this.currentValue.toString().trim();
        if (tagName.equals("user")) {
            this.inUser = false;
        } else if (tagName.equals("category")) {
            this.inCategory = false;
        } else if (tagName.equals("thing")) {
            this.thingList.add(this.currentThing);
            this.currentThing = null;
        } else if (this.inUser) {
            if (tagName.equals("id")) {
                this.currentThing.userId = Integer.parseInt(value);
            } else if (tagName.equals("username")) {
                this.currentThing.userName = value;
            }
        } else if (this.inCategory) {
            if (tagName.equals("id")) {
                this.currentThing.categoryId = value;
            } else if (tagName.equals("name")) {
                this.currentThing.categoryName = value;
            }
        } else if (tagName.equals("tag")) {
            this.currentThing.tags.add(value);
        } else if (tagName.equals("id")) {
            this.currentThing.id = value;
        } else if (tagName.equals("created")) {
            this.currentThing.created = new Date(Long.parseLong(value) * 1000L);
        } else if (tagName.equals("language")) {
            this.currentThing.language = value;
        } else if (tagName.equals("url")) {
            this.currentThing.url = value;
        } else if (tagName.equals("title")) {
            this.currentThing.title = value;
        } else if (tagName.equals("story")) {
            this.currentThing.description = value;
        } else if (tagName.equals("clicks")) {
            this.currentThing.clicks = Integer.parseInt(value);
        } else if (tagName.equals("username")) {
            this.currentThing.userName = value;
        } else if (tagName.equals("tag")) {
            this.currentThing.tags.add(value);
        } else if (tagName.equals("status")) {
            this.currentThing.status = value;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentValue.append(ch, start, length);
    }
}

