/*
 * Decompiled with CFR 0.152.
 */
package com.flattr4android.rest;

import com.flattr4android.rest.FlattrRestClient;
import com.flattr4android.rest.FlattrRestException;
import com.flattr4android.rest.Thing;
import com.flattr4android.rest.UserSAXHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.SAXParserFactory;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class User {
    protected int id;
    protected String userName;
    protected String firstName;
    protected String lastName;
    protected String city;
    protected String country;
    protected String avatarUrl;
    protected String email;
    protected String description;
    protected int thingCount;
    FlattrRestClient fr;

    private User(FlattrRestClient fr) {
        this.fr = fr;
    }

    public ArrayList<Thing> getThings() throws OAuthMessageSignerException, OAuthExpectationFailedException, OAuthCommunicationException, FlattrRestException, IOException {
        return this.fr.getUserThings(this.getId());
    }

    public int getId() {
        return this.id;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEmail() {
        return this.email;
    }

    public int getThingCount() {
        return this.thingCount;
    }

    public String toString() {
        return String.valueOf(this.getUserName()) + (this.getFirstName() != null && this.getLastName() != null ? " (" + this.getFirstName() + " " + this.getLastName() + ")" : "");
    }

    public static User buildUser(FlattrRestClient fr, InputStream xmlDescription) throws FlattrRestException {
        User user = new User(fr);
        try {
            XMLReader parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            parser.setContentHandler(new UserSAXHandler(user));
            parser.parse(new InputSource(xmlDescription));
        }
        catch (Exception e) {
            throw new FlattrRestException(e);
        }
        return user;
    }
}

