/*
 * Decompiled with CFR 0.152.
 */
package com.flattr4android.rest;

import com.flattr4android.rest.PortableSAXHandler;
import com.flattr4android.rest.User;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class UserSAXHandler
extends PortableSAXHandler {
    private User user;
    private StringBuilder currentValue = new StringBuilder();

    public UserSAXHandler(User user) {
        this.user = user;
    }

    @Override
    public void startElement(String nsURI, String localName, String tagName, Attributes attributes) throws SAXException {
        this.currentValue = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentValue.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String tagName = this.getTagName(localName, qName);
        String value = this.currentValue.toString().trim();
        if (tagName.equalsIgnoreCase("id")) {
            this.user.id = Integer.parseInt(value);
        } else if (tagName.equalsIgnoreCase("username")) {
            this.user.userName = value;
        } else if (tagName.equalsIgnoreCase("firstname")) {
            this.user.firstName = value;
        } else if (tagName.equalsIgnoreCase("lastname")) {
            this.user.lastName = value;
        } else if (tagName.equalsIgnoreCase("city")) {
            this.user.city = value;
        } else if (tagName.equalsIgnoreCase("country")) {
            this.user.country = value;
        } else if (tagName.equalsIgnoreCase("gravatar")) {
            this.user.avatarUrl = value;
        } else if (tagName.equalsIgnoreCase("email")) {
            this.user.email = value;
        } else if (tagName.equalsIgnoreCase("description")) {
            this.user.description = value;
        } else if (tagName.equalsIgnoreCase("thingcount")) {
            this.user.thingCount = Integer.parseInt(value);
        }
    }
}

