/*
 * Decompiled with CFR 0.152.
 */
package com.flattr4android.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.flattr4android.rest.FlattrRestClient;
import com.flattr4android.rest.Thing;
import com.flattr4android.sdk.FlattrSDK;
import com.flattr4android.sdk.FlattrSDKException;

public class FlattrButton
extends View {
    public static final String BUTTON_STYLE_VERTICAL = "vertical";
    public static final String BUTTON_STYLE_HORIZONTAL = "horizontal";
    public static final int CLICK_TEXT_COLOR = -16777216;
    private boolean verticalResIntialized = false;
    private Drawable buttonTop;
    private int buttonTopWidth;
    private int buttonTopHeight;
    private Drawable buttonVMiddle;
    private int buttonVMiddleWidth;
    private int buttonVMiddleHeight;
    private Drawable buttonBottomFlattr;
    private Drawable buttonBottomFlattred;
    private Drawable buttonBottomMyThing;
    private Drawable buttonBottomInactive;
    private int buttonBottomWidth;
    private int buttonBottomHeight;
    private TextPaint verticalClickPaint;
    private float verticalClickTextHeight;
    private boolean horizontalResIntialized = false;
    private Drawable buttonLeftFlattr;
    private Drawable buttonLeftFlattred;
    private Drawable buttonLeftMyThing;
    private Drawable buttonLeftInactive;
    private int buttonLeftWidth;
    private int buttonLeftHeight;
    private Drawable buttonHMiddle;
    private int buttonHMiddleWidth;
    private int buttonHMiddleHeight;
    private Drawable buttonRight;
    private int buttonRightWidth;
    private int buttonRightHeight;
    private TextPaint horizontalClickPaint;
    private float horizontalClickTextHeight;
    private String style = "horizontal";
    private FlattrRestClient flattrClient;
    private String thingId;
    private int thingStatus;
    private int thingClicks;
    private boolean thingSet = false;
    private boolean thingGotAsUser;
    private Exception thingError;

    public FlattrButton(Context context) throws FlattrSDKException {
        super(context);
        this.initResources();
        this.initListener();
    }

    public FlattrButton(Context context, AttributeSet attrs) throws FlattrSDKException {
        super(context, attrs);
        this.setThingId(this.getAttribute(attrs, "thing_id"));
        this.setFlattrCredentials(this.getAttribute(attrs, "token"), this.getAttribute(attrs, "token_secret"));
        String style = this.getAttribute(attrs, "button_style", false);
        if (style != null) {
            this.setButtonStyle(style);
        }
        this.initResources();
        this.initListener();
    }

    private void initListener() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    FlattrSDK.displayThing(FlattrButton.this.getContext(), FlattrButton.this.thingId);
                }
                catch (FlattrSDKException e) {
                    Log.d((String)"FlattrSdk", (String)("Error while displaying thing " + FlattrButton.this.thingId), (Throwable)e);
                }
            }
        });
    }

    public void setFlattrCredentials(String token, String tokenSecret) {
        this.flattrClient = new FlattrRestClient("rrdeL1qORFfpByYHXXMsUDtbjkoLf2txkxBWoSA6nGlP4anSX0aHtuJDEYeKQy71", "VzNaie6vKiaEion6eoDxId1c15NIuKzfadfihbERkFmsTzoXNSllVcoN81msCLxD", token, tokenSecret);
        if (this.thingId != null) {
            new ThingLoader(this.flattrClient, this.thingId).execute(new Void[0]);
        }
    }

    public void setThingId(String thingId) {
        this.thingId = thingId;
        if (this.flattrClient != null) {
            new ThingLoader(this.flattrClient, thingId).execute(new Void[0]);
        }
    }

    public String getThingId() {
        return this.thingId;
    }

    public void setButtonStyle(String style) throws FlattrSDKException {
        if (!style.equals(BUTTON_STYLE_HORIZONTAL) && !style.equals(BUTTON_STYLE_VERTICAL)) {
            throw new IllegalArgumentException("Invalid style '" + style + "' (only " + BUTTON_STYLE_HORIZONTAL + " and " + BUTTON_STYLE_VERTICAL + " are allowed)");
        }
        this.style = style;
        this.initResources();
        this.invalidate();
    }

    public String getButtonStyle() {
        return this.style;
    }

    private String getAttribute(AttributeSet attrs, String attrName) throws FlattrSDKException {
        return FlattrSDK.resolveStringRef(this.getAttribute(attrs, attrName, true), this.getContext());
    }

    private String getAttribute(AttributeSet attrs, String attrName, boolean mandatory) throws FlattrSDKException {
        String value = attrs.getAttributeValue("http://schemas.flattr4android.com/sdk", attrName);
        if (mandatory && value == null) {
            throw new FlattrSDKException("Cannot find attribute '" + attrName + "'. Please make sure you set it with the namespace '" + "http://schemas.flattr4android.com/sdk" + "'");
        }
        return value;
    }

    private void initResources() throws FlattrSDKException {
        if (this.style.equals(BUTTON_STYLE_HORIZONTAL)) {
            if (this.verticalResIntialized) {
                this.verticalResIntialized = false;
                this.buttonTop = null;
                this.buttonVMiddle = null;
                this.buttonBottomFlattr = null;
                this.buttonBottomFlattred = null;
                this.buttonBottomMyThing = null;
                this.buttonBottomInactive = null;
                this.verticalClickPaint = null;
            }
            if (!this.horizontalResIntialized) {
                this.buttonLeftFlattr = this.getResources().getDrawable(FlattrSDK.getResourceId("flattr_sdk_button_horizontal_left_flattr", "drawable", this.getContext()));
                ((BitmapDrawable)this.buttonLeftFlattr).setAntiAlias(true);
                this.buttonLeftFlattred = this.getResources().getDrawable(FlattrSDK.getResourceId("flattr_sdk_button_horizontal_left_flattred", "drawable", this.getContext()));
                ((BitmapDrawable)this.buttonLeftFlattred).setAntiAlias(true);
                this.buttonLeftMyThing = this.getResources().getDrawable(FlattrSDK.getResourceId("flattr_sdk_button_horizontal_left_mything", "drawable", this.getContext()));
                ((BitmapDrawable)this.buttonLeftMyThing).setAntiAlias(true);
                this.buttonLeftInactive = this.getResources().getDrawable(FlattrSDK.getResourceId("flattr_sdk_button_horizontal_left_inactive", "drawable", this.getContext()));
                ((BitmapDrawable)this.buttonLeftInactive).setAntiAlias(true);
                Bitmap tmp = ((BitmapDrawable)this.buttonLeftFlattr).getBitmap();
                this.buttonLeftWidth = tmp.getWidth();
                this.buttonLeftHeight = tmp.getHeight();
                this.buttonHMiddle = this.getResources().getDrawable(FlattrSDK.getResourceId("flattr_sdk_button_horizontal_middle", "drawable", this.getContext()));
                ((BitmapDrawable)this.buttonHMiddle).setAntiAlias(true);
                tmp = ((BitmapDrawable)this.buttonHMiddle).getBitmap();
                this.buttonHMiddleWidth = tmp.getWidth();
                this.buttonHMiddleHeight = tmp.getHeight();
                this.buttonRight = this.getResources().getDrawable(FlattrSDK.getResourceId("flattr_sdk_button_horizontal_right", "drawable", this.getContext()));
                ((BitmapDrawable)this.buttonRight).setAntiAlias(true);
                tmp = ((BitmapDrawable)this.buttonRight).getBitmap();
                this.buttonRightWidth = tmp.getWidth();
                this.buttonRightHeight = tmp.getHeight();
                this.horizontalClickPaint = new TextPaint(1);
                this.horizontalClickPaint.setColor(-16777216);
                this.horizontalClickPaint.setTextAlign(Paint.Align.CENTER);
                this.horizontalClickPaint.setTextSize((float)this.buttonRightHeight / 2.0f);
                Paint.FontMetrics metrics = this.horizontalClickPaint.getFontMetrics();
                this.horizontalClickTextHeight = metrics.ascent + metrics.descent;
                this.horizontalResIntialized = true;
            }
        } else if (this.style.equals(BUTTON_STYLE_VERTICAL)) {
            if (this.horizontalResIntialized) {
                this.horizontalResIntialized = false;
                this.buttonLeftFlattr = null;
                this.buttonLeftFlattred = null;
                this.buttonLeftMyThing = null;
                this.buttonLeftInactive = null;
                this.buttonHMiddle = null;
                this.buttonRight = null;
                this.horizontalClickPaint = null;
            }
            if (!this.verticalResIntialized) {
                this.buttonTop = this.getResources().getDrawable(FlattrSDK.getResourceId("flattr_sdk_button_vertical_top", "drawable", this.getContext()));
                Bitmap tmp = ((BitmapDrawable)this.buttonTop).getBitmap();
                this.buttonTopWidth = tmp.getWidth();
                this.buttonTopHeight = tmp.getHeight();
                this.buttonVMiddle = this.getResources().getDrawable(FlattrSDK.getResourceId("flattr_sdk_button_vertical_middle", "drawable", this.getContext()));
                tmp = ((BitmapDrawable)this.buttonVMiddle).getBitmap();
                this.buttonVMiddleWidth = tmp.getWidth();
                this.buttonVMiddleHeight = tmp.getHeight();
                this.buttonBottomFlattr = this.getResources().getDrawable(FlattrSDK.getResourceId("flattr_sdk_button_vertical_bottom_flattr", "drawable", this.getContext()));
                ((BitmapDrawable)this.buttonBottomFlattr).setAntiAlias(true);
                this.buttonBottomFlattred = this.getResources().getDrawable(FlattrSDK.getResourceId("flattr_sdk_button_vertical_bottom_flattred", "drawable", this.getContext()));
                ((BitmapDrawable)this.buttonBottomFlattred).setAntiAlias(true);
                this.buttonBottomMyThing = this.getResources().getDrawable(FlattrSDK.getResourceId("flattr_sdk_button_vertical_bottom_mything", "drawable", this.getContext()));
                ((BitmapDrawable)this.buttonBottomMyThing).setAntiAlias(true);
                this.buttonBottomInactive = this.getResources().getDrawable(FlattrSDK.getResourceId("flattr_sdk_button_vertical_bottom_inactive", "drawable", this.getContext()));
                ((BitmapDrawable)this.buttonBottomInactive).setAntiAlias(true);
                tmp = ((BitmapDrawable)this.buttonBottomFlattr).getBitmap();
                this.buttonBottomWidth = tmp.getWidth();
                this.buttonBottomHeight = tmp.getHeight();
                this.verticalClickPaint = new TextPaint(1);
                this.verticalClickPaint.setColor(-16777216);
                this.verticalClickPaint.setTextAlign(Paint.Align.CENTER);
                this.verticalClickPaint.setTextSize((float)this.buttonTopHeight / 3.0f);
                Paint.FontMetrics metrics = this.verticalClickPaint.getFontMetrics();
                this.verticalClickTextHeight = metrics.ascent + metrics.descent;
                this.verticalResIntialized = true;
            }
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int measuredHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        switch (View.MeasureSpec.getMode((int)widthMeasureSpec)) {
            case 0x40000000: {
                break;
            }
            case -2147483648: 
            case 0: {
                if (this.style.equals(BUTTON_STYLE_VERTICAL)) {
                    measuredWidth = this.buttonTopWidth;
                    measuredHeight = this.buttonTopHeight + this.buttonVMiddleHeight + this.buttonBottomHeight;
                    break;
                }
                measuredWidth = this.buttonLeftWidth + this.buttonHMiddleWidth + this.buttonRightWidth;
                measuredHeight = this.buttonLeftHeight;
            }
        }
        Log.d((String)"FlattrSdk", (String)("Button dimensions: " + measuredWidth + " x " + measuredHeight));
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    public void onDraw(Canvas canvas) {
        if (this.style.equals(BUTTON_STYLE_VERTICAL)) {
            Drawable buttonBottom;
            this.buttonTop.setBounds(0, 0, this.buttonTopWidth, this.buttonTopHeight);
            this.buttonTop.draw(canvas);
            this.buttonVMiddle.setBounds(0, this.buttonTopHeight, this.buttonVMiddleWidth, this.buttonTopHeight + this.buttonVMiddleHeight);
            this.buttonVMiddle.draw(canvas);
            switch (this.getThingStatus()) {
                case 5: {
                    buttonBottom = this.buttonBottomFlattred;
                    break;
                }
                case 4: {
                    buttonBottom = this.buttonBottomInactive;
                    break;
                }
                case 2: {
                    buttonBottom = this.buttonBottomFlattr;
                    break;
                }
                case 3: {
                    buttonBottom = this.buttonBottomMyThing;
                    break;
                }
                default: {
                    buttonBottom = this.buttonBottomFlattr;
                }
            }
            buttonBottom.setBounds(0, this.buttonTopHeight + this.buttonVMiddleHeight, this.buttonBottomWidth, this.buttonTopHeight + this.buttonVMiddleHeight + this.buttonBottomHeight);
            buttonBottom.draw(canvas);
            if (this.thingSet) {
                this.drawVerticalClick(canvas, Integer.toString(this.thingClicks));
            } else if (this.thingError != null) {
                Log.d((String)"FlattrSdk", (String)"Error during thing loading", (Throwable)this.thingError);
                this.drawVerticalClick(canvas, "!");
            } else {
                this.drawVerticalClick(canvas, "?");
            }
        } else {
            Drawable buttonLeft;
            switch (this.getThingStatus()) {
                case 5: {
                    buttonLeft = this.buttonLeftFlattred;
                    break;
                }
                case 4: {
                    buttonLeft = this.buttonLeftInactive;
                    break;
                }
                case 2: {
                    buttonLeft = this.buttonLeftFlattr;
                    break;
                }
                case 3: {
                    buttonLeft = this.buttonLeftMyThing;
                    break;
                }
                default: {
                    buttonLeft = this.buttonLeftFlattr;
                }
            }
            buttonLeft.setBounds(0, 0, this.buttonLeftWidth, this.buttonLeftHeight);
            buttonLeft.draw(canvas);
            this.buttonHMiddle.setBounds(this.buttonLeftWidth, 0, this.buttonLeftWidth + this.buttonHMiddleWidth, this.buttonHMiddleHeight);
            this.buttonHMiddle.draw(canvas);
            this.buttonRight.setBounds(this.buttonLeftWidth + this.buttonHMiddleWidth, 0, this.buttonLeftWidth + this.buttonHMiddleWidth + this.buttonRightWidth, this.buttonRightHeight);
            this.buttonRight.draw(canvas);
            if (this.thingSet) {
                this.drawHorizontalClick(canvas, Integer.toString(this.thingClicks));
            } else if (this.thingError != null) {
                this.drawHorizontalClick(canvas, "!");
            } else {
                this.drawHorizontalClick(canvas, "?");
            }
        }
    }

    public int getThingStatus() {
        if (this.thingSet && this.thingGotAsUser) {
            return this.thingStatus;
        }
        return 2;
    }

    private void drawVerticalClick(Canvas canvas, String text) {
        canvas.drawText(text, (float)this.buttonTopWidth / 2.0f, ((float)this.buttonTopHeight - this.verticalClickTextHeight) / 2.0f, (Paint)this.verticalClickPaint);
    }

    private void drawHorizontalClick(Canvas canvas, String text) {
        canvas.drawText(text, (float)(this.buttonLeftWidth + this.buttonHMiddleWidth) + (float)this.buttonRightWidth / 2.0f, ((float)this.buttonRightHeight - this.horizontalClickTextHeight) / 2.0f, (Paint)this.horizontalClickPaint);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ThingLoader
    extends AsyncTask<Void, Void, Void> {
        private FlattrRestClient flattrClient;
        private String thingId;

        public ThingLoader(FlattrRestClient flattrClient, String thingId) {
            this.flattrClient = flattrClient;
            this.thingId = thingId;
            FlattrButton.this.thingSet = false;
            FlattrButton.this.thingError = null;
            FlattrButton.this.invalidate();
        }

        protected Void doInBackground(Void ... arg0) {
            try {
                ContentResolver cr = FlattrButton.this.getContext().getContentResolver();
                Cursor c = cr.query(Uri.parse((String)("content://com.flattr4android.provider.app/thing/id/" + this.thingId)), null, null, null, null);
                if (c != null && c.moveToFirst()) {
                    Log.d((String)"FlattrSdk", (String)("Thing " + this.thingId + " got from Flattr application"));
                    FlattrButton.this.thingStatus = c.getInt(c.getColumnIndex("int_status"));
                    FlattrButton.this.thingClicks = c.getInt(c.getColumnIndex("clicks"));
                    FlattrButton.this.thingGotAsUser = true;
                    FlattrButton.this.thingSet = true;
                    return null;
                }
            }
            catch (Exception e) {
                Log.d((String)"FlattrSdk", (String)("Error while trying to get thing " + this.thingId + " from Flattr application"), (Throwable)e);
                FlattrButton.this.thingError = e;
            }
            try {
                if (!FlattrButton.this.thingSet) {
                    Thing thing = this.flattrClient.getThing(this.thingId);
                    Log.d((String)"FlattrSdk", (String)("Thing " + this.thingId + " got with local means"));
                    FlattrButton.this.thingStatus = thing.getIntStatus();
                    FlattrButton.this.thingClicks = thing.getClicks();
                    FlattrButton.this.thingGotAsUser = false;
                    FlattrButton.this.thingSet = true;
                }
            }
            catch (Exception e) {
                Log.d((String)"FlattrSdk", (String)("Error while loading thing " + this.thingId + " with local means"), (Throwable)e);
                FlattrButton.this.thingError = e;
            }
            return null;
        }

        protected void onPostExecute(Void result) {
            super.onPostExecute((Object)result);
            FlattrButton.this.invalidate();
        }
    }
}

