package com.webworxshop.swallowcatcher;

import android.app.ListActivity;
import android.os.Bundle;
import android.os.IBinder;
import android.content.ServiceConnection;
import android.content.Intent;
import android.content.Context;
import android.content.ComponentName;
import android.widget.AdapterView.AdapterContextMenuInfo;
import android.view.MenuItem;
import android.view.MenuInflater;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.View;
import android.util.Log;

import java.util.ArrayList;
import java.util.List;
import java.sql.SQLException;

import com.j256.ormlite.android.apptools.OpenHelperManager;
import com.j256.ormlite.dao.Dao;

import com.webworxshop.swallowcatcher.db.Subscription;
import com.webworxshop.swallowcatcher.db.DatabaseHelper;
import com.webworxshop.swallowcatcher.downloads.DownloadService;
import com.webworxshop.swallowcatcher.downloads.Download;
import com.webworxshop.swallowcatcher.downloads.DownloadListAdapter;

public class DownloadsListActivity extends ListActivity 
{
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.downloads_list_view);
        
        doBindService();
        
        registerForContextMenu(getListView());
    }
    
    private ServiceConnection connection = new ServiceConnection()
    {
    	public void onServiceConnected(ComponentName className, IBinder service)
    	{
    		download_service = ((DownloadService.DownloadBinder)service).getService();
    		download_service.setDownloadActivity(DownloadsListActivity.this);
    		
    		//ArrayList<String> temp = new ArrayList<String>();
    		//temp.add("Hello World!");
    		adapter = new DownloadListAdapter(DownloadsListActivity.this, R.layout.downloads_list_item, download_service.getDownloads());
    		setListAdapter(adapter);
    	}
    	
    	public void onServiceDisconnected(ComponentName className)
    	{
    		download_service = null;
    		download_service.setDownloadActivity(null);
    	}
    };
    
    private void doBindService()
    {
    	getApplicationContext().bindService(new Intent(this, DownloadService.class), connection, Context.BIND_AUTO_CREATE);
    	is_bound = true;
    }
    
    private void doUnbindService()
    {
    	if(is_bound)
    	{
    		getApplicationContext().unbindService(connection);
    		is_bound = false;
    	}
    }
    
    @Override
    protected void onDestroy()
    {
    	super.onDestroy();
    	doUnbindService();
    }
    
    public void updateProgress(int progress)
    {
    	adapter.updateProgress();
    	int files = download_service.getDownloads().size();
    	if(progress < 100 && files > 0)
    	{
    		main_activity.setTitle("SwallowCatcher (downloading "+ files + ", " + progress +"%)");
    		main_activity.setProgressBarVisibility(true);
    		main_activity.setProgress(progress);
    	}
    	else
    	{
    		try
    		{
    			DatabaseHelper helper = (DatabaseHelper)OpenHelperManager.getHelper(this);
				Dao<Subscription, Object> dao = helper.getSubscriptionDao();
				List<Subscription> subs = dao.queryForAll();
    			main_activity.setTitle("SwallowCatcher (" + subs.size() +")");
    			main_activity.setProgressBarVisibility(false);
    		}
    		catch(SQLException e)
    		{
    			Log.e("SwallowCatcher", "Unable to set window title!", e);
    		}
    	}
    }
    
    @Override
	public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo)
	{
		super.onCreateContextMenu(menu, v, menuInfo);
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.downloads_context_menu, menu);
	}
	
	@Override
	public boolean onContextItemSelected(MenuItem item)
	{
		AdapterContextMenuInfo info = (AdapterContextMenuInfo) item.getMenuInfo();
		switch (item.getItemId())
		{
			case R.id.cancel_download:
				adapter.getItem((int)info.id).cancel();
				adapter.remove(adapter.getItem((int)info.id));
				adapter.notifyDataSetChanged();
				download_service.setOverallProgress();
				updateProgress(download_service.getOverallProgress());
				return true;
			default:
				return super.onContextItemSelected(item);
		}
	}
	
	public static void setMainActivity(MainActivity m)
	{
		main_activity = m;
	}
    
    private static MainActivity main_activity;    
    private DownloadService download_service;
    private boolean is_bound = false;
    private DownloadListAdapter adapter = null;
}
