package com.webworxshop.swallowcatcher;

import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.Bundle;
import android.content.Context;
import android.util.Log;
import java.io.File;
import java.io.InputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.sql.SQLException;
import org.w3c.dom.*;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;

import com.j256.ormlite.android.apptools.OpenHelperManager;
import com.j256.ormlite.dao.Dao;

import com.webworxshop.swallowcatcher.db.Subscription;
import com.webworxshop.swallowcatcher.db.DatabaseHelper;

class OpmlImportThread extends Thread
{
	public OpmlImportThread(Handler h, Context c)
	{
		handler = h;
		context = c;
	}
	
	public void run()
	{
		String state = Environment.getExternalStorageState();
		Log.i(context.getString(R.string.app_name), state);
		if(Environment.MEDIA_MOUNTED.equals(state) || Environment.MEDIA_MOUNTED_READ_ONLY.equals(state))
		{
			// try to read the file and do import
			File dir = Environment.getExternalStorageDirectory();
			File file = new File(dir, "Podcasts/import.opml");
			if(!file.exists())
			{
				sendError(OpmlImportActivity.ERROR_FILE_NO_EXIST);
				return;
			}
			else if(!file.canRead())
			{
				sendError(OpmlImportActivity.ERROR_FILE_NOT_READABLE);
				return;
			}
			ArrayList<Subscription> data;
			try
			{
				FileInputStream fstream = new FileInputStream(file);
				data = parseOPML(fstream);
				DatabaseHelper helper = (DatabaseHelper)OpenHelperManager.getHelper(context);
				Dao<Subscription, Object> dao = helper.getSubscriptionDao();
				for(Subscription sub : data)
				{
					Log.i(context.getString(R.string.app_name), "New subscription: " + sub);
					dao.create(sub);
				}
				OpenHelperManager.releaseHelper();
			}
			catch(FileNotFoundException e)
			{
				Log.e(context.getString(R.string.app_name), "OPML parsing error!", e);
				sendError(OpmlImportActivity.ERROR_FILE_NO_EXIST);
				return;
			}
			catch(RuntimeException e)
			{
				Log.e(context.getString(R.string.app_name), "OPML parsing error!", e);
				sendError(OpmlImportActivity.ERROR_PARSE);
				return;
			}
			catch(SQLException e)
			{
				Log.e(context.getString(R.string.app_name), "SQL insert error!", e);
				sendError(OpmlImportActivity.ERROR_SQL);
				return;
			}
			
			// send the message telling the main thread that we're done
			Message msg = handler.obtainMessage();
			Bundle b = new Bundle();
			b.putInt("status", OpmlImportActivity.SUCCESS_IMPORT_COMPLETE);
			b.putInt("saved", data.size());
			msg.setData(b);
			handler.sendMessage(msg);
		}
		else
		{
			sendError(OpmlImportActivity.ERROR_MEDIA_UNAVAILABLE);
		}
	}
	
	private void sendError(int err)
	{
		Message msg = handler.obtainMessage();
		Bundle b = new Bundle();
		b.putInt("status", err);
		msg.setData(b);
		handler.sendMessage(msg);
	}
	
	private ArrayList<Subscription> parseOPML(InputStream input)
	{
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		try
		{
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document dom = builder.parse(input);
			
			Node body = dom.getDocumentElement().getElementsByTagName("body").item(0);
			return parseOutlines(body);
		}
		catch(Exception e)
		{
			throw new RuntimeException(e);
		}
	}
	
	private ArrayList<Subscription> parseOutlines(Node parent)
	{
		NodeList outlines = parent.getChildNodes();
			
		ArrayList<Subscription> data = new ArrayList<Subscription>();
		for(int i = 0; i < outlines.getLength(); i++)
		{
			Node item = outlines.item(i);
			if(!item.getNodeName().equals("outline"))
			{
				continue;
			}
			if(item.hasChildNodes())
			{
				data.addAll(parseOutlines(item));
			}
			else if(item.hasAttributes())
			{
				NamedNodeMap attmap = item.getAttributes();
				Subscription sub = new Subscription(attmap.getNamedItem("title").getNodeValue(),
													attmap.getNamedItem("text").getNodeValue(),
													attmap.getNamedItem("type").getNodeValue(),
													attmap.getNamedItem("xmlUrl").getNodeValue());
				data.add(sub);
			}
		}
		return data;
	}
	
	
	private Handler handler;
	private Context context;
}
