
package com.webworxshop.swallowcatcher;

import android.widget.ArrayAdapter;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.LayoutInflater;
import android.widget.TextView;
import android.widget.ImageView;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ScaleDrawable;
import android.os.Environment;

import java.util.ArrayList;
import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

import com.webworxshop.swallowcatcher.db.Subscription;

public class PodcastsListAdapter extends ArrayAdapter<Subscription>
{
	private ArrayList<Subscription> items;
	private ArrayList<Drawable> images = new ArrayList<Drawable>();
	private Context context;
	
	public PodcastsListAdapter(Context context, int textViewResourceId, ArrayList<Subscription> items)
	{
		super(context, textViewResourceId, items);
		this.context = context;
		this.items = items;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent)
	{
		View v = convertView;
		if(v == null)
		{
			LayoutInflater vi = (LayoutInflater)context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			v = vi.inflate(R.layout.podcasts_list_item, null);
		}
		Subscription s = items.get(position);
		if(s != null)
		{
			TextView tt = (TextView)v.findViewById(R.id.podcast_title);
			if(tt != null)
			{
				tt.setText(s.toString());
			}
			Drawable img = Drawable.createFromPath(getFileName(s.getName()).getAbsolutePath());
			ImageView iv = (ImageView)v.findViewById(R.id.podcast_cover);
			if(img != null)
			{
				//img = new ScaleDrawable(img, 0, 64, 64);
				//img.setBounds(0, 0,  64, 64);
				iv.setImageDrawable(img);
			}
			else
			{
				iv.setImageResource(R.drawable.swallowcatcher);
			}
		}
		return v;
	}
	
	// TODO: these really need to go somewhere where they can be called
	// in multiple places, rather than beinng duplicated all over the place!
	/**
	 * A helper function to get a file object for a given podcast name and file name.
	 * @param podcastName
	 * @param episode 
	 * @return File ExternalStorageDirectory / Podcasts / podcastName / Title - filename
	 */
	public static File getFileName(String podcastName) {
		//Trim is necessary since a directory can't end with spaces.
		String path = makeSafe(podcastName.trim()) + "/" + makeSafe("cover.jpg");

		// the path needs converting to make sure it's a valid path name
		Pattern p = Pattern.compile("[?><\\:*|^]");
		Matcher m = p.matcher(path);
		path = m.replaceAll("_");
		
		File dir = Environment.getExternalStorageDirectory(); 
		return new File(dir, "Podcasts/" + path);
	}
	
	/**
	 * Makes a filename safe by removing non-supported characters.
	 * @param filename
	 * @return filename with unsafe characters removed.
	 */
	private static String makeSafe(String filename) {
		StringBuilder fixedName = new StringBuilder();
		for (int c=0; c<filename.length(); c++) { // Make a valid name:
			if (VALIDCHARS.indexOf(filename.charAt(c))>-1) {
				fixedName.append(filename.charAt(c));
			}
		}
		return fixedName.toString();
	}
	
	private final static String VALIDCHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 $%`-_@{}~!#().";

}
