package com.webworxshop.swallowcatcher;

import android.app.Activity;
import android.os.Bundle;
import android.content.Intent;
import android.webkit.WebView;
import android.util.Log;

import java.sql.SQLException;
import java.net.URLEncoder;
import java.io.UnsupportedEncodingException;

import com.j256.ormlite.android.apptools.OpenHelperManager;
import com.j256.ormlite.dao.Dao;

import com.webworxshop.swallowcatcher.db.Episode;
import com.webworxshop.swallowcatcher.db.DatabaseHelper;

public class ShowNotesActivity extends Activity 
{
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
        setContentView(R.layout.shownotes_view);
        
        Intent i = getIntent();
		int id = i.getIntExtra("episode", -1);
		
		try
		{
			DatabaseHelper helper = (DatabaseHelper)OpenHelperManager.getHelper(this);
			Dao<Episode, Object> dao = helper.getEpisodeDao();
			
			Episode ep = dao.queryForId(id);
			setTitle(ep.toString());
			
			// the webview needs its content urlencoded, but with spaces as spaces
			// for some reason
			String text = URLEncoder.encode(ep.getDescription(), "utf-8");
			text = text.replace('+', ' ');
			
			WebView web = (WebView)findViewById(R.id.shownotes);
			web.loadData(text, "text/html", "utf-8");
		}
		catch(SQLException e)
		{
			Log.e("SwallowCatcher", "Unable to find episode!", e);
		}
		catch(UnsupportedEncodingException e)
		{
			Log.e("SwallowCatcher", "Unable to encode content!", e);
		}
	}
}

