package com.webworxshop.swallowcatcher.db;

import android.util.Log;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.text.ParseException;
import java.util.TimeZone;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;

@DatabaseTable(tableName = "episodes")
public class Episode implements Serializable
{
	public Episode()
	{
	}
	
	public String toString()
	{
		return title;
	}
	
	/**
	 * Returns the unique identifier for this episode.
	 * @return
	 */
	public int getID()
	{
		return id;
	}
	
	public String getTitle()
	{
		return title;
	}
	
	public void setTitle(String t)
	{
		title = t;
	}
	
	public String getLink()
	{
		return link;
	}
	
	public void setLink(String l)
	{
		link = l;
	}
	
	public String getDescription()
	{
		return description;
	}
	
	public void setDescription(String d)
	{
		description = d;
	}
	
	/**
	 * Returns the date as millisecond value. The number of milliseconds since Jan. 1, 1970, midnight GMT.
	 * @return long number
	 */
	public long getDate()
	{
		return date;
	}
	
	public void setDate(String d)
	{
		try
		{
			if(d.contains("BST"))
			{
				TimeZone.setDefault(tzGMT);
				SimpleDateFormat dfBST = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
				dfBST.setTimeZone(tzEL);
				date = dfBST.parse(d).getTime();
			}
			else
			{
				date = df.parse(d).getTime();
			}
		}
		catch(ParseException e)
		{
			Log.e("SwallowCatcher", "Error parsing date!", e);
		}
	}
	
	/**
	 * Returns the download url of this episode.
	 * @return
	 */
	public String getFileLink()
	{
		return file_link;
	}
	
	/**
	 * Sets the file download link for this episode.
	 * @param String url.
	 */
	public void setFileLink(String f)
	{
		file_link = f;
	}
	
	public String getGUID()
	{
		return guid;
	}
	
	public void setGUID(String g)
	{
		guid = g;
	}
	
	public Subscription getSubscription()
	{
		return sub;
	}
	
	public void setSubscription(Subscription s)
	{
		sub = s;
	}
	
	/**
	 * Returns a string description of the status.
	 * @return String - "downloaded" if fully downloaded.
	 */
	public String getStatus()
	{
		return status;
	}
	
	public void setStatus(String s)
	{
		status = s;
	}
	
	public static final String COL_ID = "_id";
	public static final String COL_SUB = "subscription";
	public static final String COL_GUID = "guid";
	public static final String COL_TITLE = "title";
	public static final String COL_LINK = "link";
	public static final String COL_DESC = "description";
	public static final String COL_DATE = "date";
	public static final String COL_FILELINK = "file_link";
	public static final String COL_STATUS = "status";
	
	private static final SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
	private static final TimeZone tzEL = TimeZone.getTimeZone("Europe/London");
	private static final TimeZone tzGMT = TimeZone.getTimeZone("GMT0");
	
	@DatabaseField(generatedId = true, columnName=COL_ID)
	private int id;
	@DatabaseField(columnName=COL_SUB, foreign=true)
	private Subscription sub;
	@DatabaseField(columnName=COL_GUID)
	private String guid;
	@DatabaseField(columnName=COL_TITLE)
	private String title;
	@DatabaseField(columnName=COL_LINK)
	private String link;
	@DatabaseField(columnName=COL_DESC)
	private String description;
	@DatabaseField(columnName=COL_DATE)
	private long date;
	@DatabaseField(columnName=COL_FILELINK)
	private String file_link;
	@DatabaseField(columnName=COL_STATUS)
	private String status;
}

