package com.webworxshop.swallowcatcher.db;

import java.io.Serializable;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;

@DatabaseTable(tableName = "subscriptions")
public class Subscription implements Serializable
{
	public Subscription()
	{
	}

	public Subscription(String n, String d, String t, String u)
	{
		name = n;
		description = d;
		type = t;
		url = u;
	}
	
	public Subscription(String u)
	{
		url = u;
		name = u;
	}
	
	public String toString()
	{
		return name;
	}
	
	public int getID()
	{
		return id;
	}
	
	public String getName()
	{
		return name;
	}
	
	public void setName(String n)
	{
		name = n;
	}
	
	public String getDescription()
	{
		return description;
	}
	
	public void setDescription(String d)
	{
		description = d;
	}
	
	public String getType()
	{
		return type;
	}
	
	public void setType(String t)
	{
		type = t;
	}
	
	public String getURL()
	{
		return url;
	}
	
	public void setURL(String u)
	{
		url = u;
	}
	
	public boolean getNew()
	{
		return isNew;
	}
	
	public void setNew(boolean n)
	{
		isNew = n;
	}
	
	public static final String COL_ID = "_id";
	public static final String COL_NAME = "name";
	public static final String COL_DESC = "desc";
	public static final String COL_TYPE = "type";
	public static final String COL_URL = "url";
	public static final String COL_NEW = "new";
	
	@DatabaseField(generatedId = true, columnName=COL_ID)
	private int id;
	@DatabaseField(columnName=COL_NAME)
	private String name;
	@DatabaseField(columnName=COL_DESC)
	private String description;
	@DatabaseField(columnName=COL_TYPE)
	private String type;
	@DatabaseField(columnName=COL_URL)
	private String url;
	@DatabaseField(columnName=COL_NEW)
	private boolean isNew = true;
}

