
package com.webworxshop.swallowcatcher.downloads;

import android.app.Service;
import android.os.Binder;
import android.os.IBinder;
import android.os.Bundle;
import android.os.Message;
import android.os.Handler;
import android.util.Log;
import android.content.Intent;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiManager.WifiLock;
import android.os.PowerManager;
import android.os.PowerManager.WakeLock;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.widget.RemoteViews;

import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ExecutorService;

import com.j256.ormlite.android.apptools.OpenHelperManager;
import com.j256.ormlite.dao.Dao;

import com.webworxshop.swallowcatcher.DownloadsListActivity;
import com.webworxshop.swallowcatcher.R;
import com.webworxshop.swallowcatcher.MainActivity;
import com.webworxshop.swallowcatcher.db.Episode;

public class DownloadService extends Service
{
	// we implement the local service model as we should always be communicating with the same process
	public class DownloadBinder extends Binder
	{
		public DownloadService getService()
		{
			return DownloadService.this;
		}
	}
	
	@Override
	public void onCreate()
	{
		super.onCreate();
		
		WifiManager wm = (WifiManager)getSystemService(Context.WIFI_SERVICE);
		wl = wm.createWifiLock(WifiManager.WIFI_MODE_FULL, "SwallowCatcher Download Lock");
		wl.setReferenceCounted(true);
		
		PowerManager pm = (PowerManager)getSystemService(Context.POWER_SERVICE);
		pl = pm.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, "SwallowCatcher Download Lock");
		pl.setReferenceCounted(true);
		
		nm = (NotificationManager)getSystemService(NOTIFICATION_SERVICE);
	}
	
	public int onStartCommand(Intent intent, int flags, int startId)
	{
		Log.i("SwallowCatcher", "Download Service started");
	
		// unpack the intent and start the download
		Episode e = (Episode)intent.getExtras().getSerializable("episode");
		startDownload(e);
		
		return START_STICKY;
	}
	
	@Override
	public void onDestroy()
	{
		super.onDestroy();
	}
	
	@Override
	public IBinder onBind(Intent intent)
	{
		Log.i("SwallowCatcher", "Download Service bound");
		
		// unpack the intent and start the download
		//String url = intent.getStringExtra("url");
		//String path = intent.getStringExtra("path");
		//startDownload(url, path);
		
		//createNotification();
		
		return binder;
	}
	
	public void startDownload(Episode e)
	{
		Download d = new Download(this, e, wl, pl, progressUpdateHandler); 
		downloads.add(d);
		downloadExecutor.submit(d);
			
		createNotification();
	}
	
	public void setDownloadActivity(DownloadsListActivity a)
	{
		activity = a;
	}
	
	public ArrayList<Download> getDownloads()
	{
		return downloads;
	}
	
	public Handler progressUpdateHandler = new Handler()
	{
		@Override
		public void handleMessage(Message message)
		{
			Bundle data = message.getData();
			String url = data.getString("url");
			int progress = data.getInt("progress");
			
			setOverallProgress();
			if(activity != null)
			{
				activity.updateProgress(overall_progress);
			}
		}
	};
	
	private void createNotification()
	{
		String text = "Downloading " + downloads.size();
		if(downloads.size() > 1)
		{
			text += " Podcasts: ";
		}
		else
		{
			text += " Podcast: ";
		}
		text += overall_progress + "%";
		notification = new Notification(R.drawable.statusbar, text, System.currentTimeMillis());
	
		contentView = new RemoteViews(getPackageName(), R.layout.downloads_notification);
		contentView.setTextViewText(R.id.download_notification_text, text);
		contentView.setProgressBar(R.id.download_notification_progress, 100, overall_progress, false);
		notification.contentView = contentView;
		
		Intent notificationIntent = new Intent(this, MainActivity.class);
		PendingIntent contentIntent = PendingIntent.getActivity(this, 0, notificationIntent, 0);
		notification.contentIntent = contentIntent;
		
		notification.flags = Notification.FLAG_ONGOING_EVENT;
		notification.number = downloads.size();
		nm.notify(R.layout.downloads_notification, notification);
	}
	
	public synchronized void setOverallProgress()
	{
		long t1 = 0, t2 = 0;
		for(Download d : downloads)
		{
			if(d.getCanceled())
			{
				downloads.remove(d);
			}
			t1 += d.getOffset();
			t2 += d.getLength();
		}
		overall_progress = (int)(((double)t1 / (double)t2) * 100);
		Log.i("SwallowCatcher", "Overall download progress: " + overall_progress + "%");
		
		if(contentView != null)
		{
			String text = "Downloading " + downloads.size();
			if(downloads.size() > 1)
			{
				text += " Podcasts: ";
			}
			else
			{
				text += " Podcast: ";
			}
			text += overall_progress + "%";
			contentView.setTextViewText(R.id.download_notification_text, text);
			contentView.setProgressBar(R.id.download_notification_progress, 100, overall_progress, false);
			nm.notify(R.layout.downloads_notification, notification);
		}
		
		if(overall_progress >= 100 || downloads.size() == 0)
		{
			nm.cancel(R.layout.downloads_notification);
			stopSelf();
		}
	}
	
	public int getOverallProgress()
	{
		return overall_progress;
	}

	private WifiLock wl;
	private WakeLock pl;
	private NotificationManager nm;
	private Notification notification = null;
	private RemoteViews contentView = null;
	private DownloadsListActivity activity = null;
	private final IBinder binder = new DownloadBinder();
	private ArrayList<Download> downloads = new ArrayList<Download>();
	private ExecutorService downloadExecutor = Executors.newFixedThreadPool(MAX_THREADS);
	private int overall_progress = 0;

	public static int MAX_THREADS = 4;
}
