/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.location;

import java.util.ArrayList;
import org.osmdroid.bonuspack.location.POI;
import org.osmdroid.util.GeoPoint;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class GeoNamesXMLHandler
extends DefaultHandler {
    private String mString;
    double mLat;
    double mLng;
    POI mPOI;
    ArrayList<POI> mPOIs = new ArrayList();

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (localName.equals("entry")) {
            this.mPOI = new POI(POI.POI_SERVICE_GEONAMES_WIKIPEDIA);
        }
        this.mString = new String();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        this.mString = this.mString.concat(chars);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (localName.equals("lat")) {
            this.mLat = Double.parseDouble(this.mString);
        } else if (localName.equals("lng")) {
            this.mLng = Double.parseDouble(this.mString);
        } else if (localName.equals("feature")) {
            this.mPOI.mCategory = this.mString;
        } else if (localName.equals("title")) {
            this.mPOI.mType = this.mString;
        } else if (localName.equals("summary")) {
            this.mPOI.mDescription = this.mString;
        } else if (localName.equals("thumbnailImg")) {
            if (this.mString != null && !this.mString.equals("")) {
                this.mPOI.mThumbnailPath = this.mString;
            }
        } else if (localName.equals("wikipediaUrl")) {
            if (this.mString != null && !this.mString.equals("")) {
                this.mPOI.mUrl = "http://" + this.mString;
            }
        } else if (localName.equals("rank")) {
            this.mPOI.mRank = Integer.parseInt(this.mString);
        } else if (localName.equals("entry")) {
            this.mPOI.mLocation = new GeoPoint(this.mLat, this.mLng);
            this.mPOIs.add(this.mPOI);
        }
    }
}

