/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.overlays;

import android.content.Context;
import android.graphics.Point;
import android.util.Log;
import java.util.List;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.bonuspack.overlays.DefaultInfoWindow;
import org.osmdroid.bonuspack.overlays.ExtendedOverlayItem;
import org.osmdroid.bonuspack.overlays.InfoWindow;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.ItemizedIconOverlay;
import org.osmdroid.views.overlay.OverlayItem;
import org.osmdroid.views.safecanvas.ISafeCanvas;

public class ItemizedOverlayWithBubble<Item extends OverlayItem>
extends ItemizedIconOverlay<Item> {
    protected InfoWindow mBubble;
    protected OverlayItem mItemWithBubble;
    static int layoutResId = 0;

    public ItemizedOverlayWithBubble(Context context, List<Item> aList, MapView mapView, InfoWindow bubble) {
        super(context, aList, new ItemizedIconOverlay.OnItemGestureListener<Item>(){

            public boolean onItemSingleTapUp(int index, OverlayItem item) {
                return false;
            }

            public boolean onItemLongPress(int index, OverlayItem item) {
                return false;
            }
        });
        if (bubble != null) {
            this.mBubble = bubble;
        } else {
            String packageName = context.getPackageName();
            if (layoutResId == 0 && (layoutResId = context.getResources().getIdentifier("layout/bonuspack_bubble", null, packageName)) == 0) {
                Log.e((String)"BONUSPACK", (String)("ItemizedOverlayWithBubble: layout/bonuspack_bubble not found in " + packageName));
            }
            this.mBubble = new DefaultInfoWindow(layoutResId, mapView);
        }
        this.mItemWithBubble = null;
    }

    public ItemizedOverlayWithBubble(Context context, List<Item> aList, MapView mapView) {
        this(context, aList, mapView, null);
    }

    public void showBubbleOnItem(ExtendedOverlayItem eItem, MapView mapView, boolean panIntoView) {
        this.mItemWithBubble = eItem;
        if (eItem != null) {
            eItem.showBubble(this.mBubble, mapView, panIntoView);
        }
    }

    public void showBubbleOnItem(int index, MapView mapView, boolean panIntoView) {
        ExtendedOverlayItem eItem = (ExtendedOverlayItem)this.getItem(index);
        this.showBubbleOnItem(eItem, mapView, panIntoView);
    }

    public void hideBubble() {
        this.mBubble.close();
        this.mItemWithBubble = null;
    }

    protected boolean onSingleTapUpHelper(int index, Item item, MapView mapView) {
        this.showBubbleOnItem(index, mapView, true);
        return true;
    }

    public OverlayItem getBubbledItem() {
        if (this.mBubble.isOpen()) {
            return this.mItemWithBubble;
        }
        return null;
    }

    public int getBubbledItemId() {
        OverlayItem item = this.getBubbledItem();
        if (item == null) {
            return -1;
        }
        return this.mItemList.indexOf(item);
    }

    public synchronized Item removeItem(int position) {
        OverlayItem result = super.removeItem(position);
        if (this.mItemWithBubble == result) {
            this.hideBubble();
        }
        return (Item)result;
    }

    public synchronized boolean removeItem(Item item) {
        boolean result = super.removeItem(item);
        if (this.mItemWithBubble == item) {
            this.hideBubble();
        }
        return result;
    }

    public synchronized void removeAllItems() {
        super.removeAllItems();
        this.hideBubble();
    }

    public synchronized void drawSafe(ISafeCanvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        MapView.Projection pj = mapView.getProjection();
        int size = this.mItemList.size() - 1;
        Point mCurScreenCoords = new Point();
        int i = size;
        while (i >= 0) {
            OverlayItem item = this.getItem(i);
            if (item != this.mItemWithBubble) {
                pj.toMapPixels((IGeoPoint)item.mGeoPoint, mCurScreenCoords);
                this.onDrawItem(canvas.getSafeCanvas(), item, mCurScreenCoords);
            }
            --i;
        }
        if (this.mItemWithBubble != null) {
            pj.toMapPixels((IGeoPoint)this.mItemWithBubble.mGeoPoint, mCurScreenCoords);
            this.onDrawItem(canvas.getSafeCanvas(), this.mItemWithBubble, mCurScreenCoords);
        }
    }
}

