/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import org.osmdroid.bonuspack.routing.RoadLeg;
import org.osmdroid.bonuspack.routing.RoadNode;
import org.osmdroid.bonuspack.utils.DouglasPeuckerReducer;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;

public class Road
implements Parcelable {
    public int mStatus;
    public double mLength;
    public double mDuration;
    public ArrayList<RoadNode> mNodes;
    public ArrayList<RoadLeg> mLegs;
    public ArrayList<GeoPoint> mRouteHigh;
    private ArrayList<GeoPoint> mRouteLow;
    public BoundingBoxE6 mBoundingBox;
    public static final int STATUS_INVALID = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_DEFAULT = 2;
    public static final Parcelable.Creator<Road> CREATOR = new Parcelable.Creator<Road>(){

        public Road createFromParcel(Parcel source) {
            return new Road(source, null);
        }

        public Road[] newArray(int size) {
            return new Road[size];
        }
    };

    private void init() {
        this.mStatus = 0;
        this.mLength = 0.0;
        this.mDuration = 0.0;
        this.mNodes = new ArrayList();
        this.mRouteHigh = new ArrayList();
        this.mRouteLow = null;
        this.mLegs = new ArrayList();
        this.mBoundingBox = null;
    }

    public Road() {
        this.init();
    }

    public Road(ArrayList<GeoPoint> waypoints) {
        this.init();
        int n = waypoints.size();
        int i = 0;
        while (i < n) {
            GeoPoint p = waypoints.get(i);
            this.mRouteHigh.add(p);
            ++i;
        }
        i = 0;
        while (i < n - 1) {
            RoadLeg leg = new RoadLeg();
            this.mLegs.add(leg);
            ++i;
        }
        this.mBoundingBox = BoundingBoxE6.fromGeoPoints(this.mRouteHigh);
        this.mStatus = 2;
    }

    public ArrayList<GeoPoint> getRouteLow() {
        if (this.mRouteLow == null) {
            int n = this.mRouteHigh.size();
            this.mRouteLow = DouglasPeuckerReducer.reduceWithTolerance(this.mRouteHigh, 1500.0);
            Log.d((String)"BONUSPACK", (String)("Road reduced from " + n + " to " + this.mRouteLow.size() + " points"));
        }
        return this.mRouteLow;
    }

    public void setRouteLow(ArrayList<GeoPoint> route) {
        this.mRouteLow = route;
    }

    public String getLengthDurationText(double length, double duration) {
        String result = length >= 100.0 ? String.valueOf((int)length) + "km, " : (length >= 1.0 ? String.valueOf((double)Math.round(length * 10.0) / 10.0) + "km, " : String.valueOf((int)(length * 1000.0)) + "m, ");
        int totalSeconds = (int)duration;
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds / 60 - hours * 60;
        int seconds = totalSeconds % 60;
        if (hours != 0) {
            result = String.valueOf(result) + hours + "h ";
        }
        if (minutes != 0) {
            result = String.valueOf(result) + minutes + "min ";
        }
        if (hours == 0 && minutes == 0) {
            result = String.valueOf(result) + seconds + "sec";
        }
        return result;
    }

    public String getLengthDurationText(int leg) {
        double length = leg == -1 ? this.mLength : this.mLegs.get((int)leg).mLength;
        double duration = leg == -1 ? this.mDuration : this.mLegs.get((int)leg).mDuration;
        return this.getLengthDurationText(length, duration);
    }

    protected double distanceLLSquared(GeoPoint p1, GeoPoint p2) {
        double deltaLat = p2.getLatitudeE6() - p1.getLatitudeE6();
        double deltaLon = p2.getLongitudeE6() - p1.getLongitudeE6();
        return deltaLat * deltaLat + deltaLon * deltaLon;
    }

    public void buildLegs(ArrayList<GeoPoint> waypoints) {
        this.mLegs = new ArrayList();
        int firstNodeIndex = 0;
        int w = waypoints.size();
        int n = this.mNodes.size();
        int i = 1;
        while (i < w - 1) {
            GeoPoint waypoint = waypoints.get(i);
            double distanceMin = -1.0;
            int nodeIndexMin = -1;
            int j = firstNodeIndex;
            while (j < n) {
                GeoPoint roadPoint = this.mNodes.get((int)j).mLocation;
                double dSquared = this.distanceLLSquared(roadPoint, waypoint);
                if (nodeIndexMin == -1 || dSquared < distanceMin) {
                    distanceMin = dSquared;
                    nodeIndexMin = j;
                }
                ++j;
            }
            RoadLeg leg = new RoadLeg(firstNodeIndex, nodeIndexMin, this.mNodes);
            this.mLegs.add(leg);
            firstNodeIndex = nodeIndexMin + 1;
            ++i;
        }
        RoadLeg lastLeg = new RoadLeg(firstNodeIndex, n - 1, this.mNodes);
        this.mLegs.add(lastLeg);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mStatus);
        out.writeDouble(this.mLength);
        out.writeDouble(this.mDuration);
        out.writeList(this.mNodes);
        out.writeList(this.mLegs);
        out.writeList(this.mRouteHigh);
        out.writeParcelable((Parcelable)this.mBoundingBox, 0);
    }

    private Road(Parcel in) {
        this.mStatus = in.readInt();
        this.mLength = in.readDouble();
        this.mDuration = in.readDouble();
        this.mNodes = in.readArrayList(RoadNode.class.getClassLoader());
        this.mLegs = in.readArrayList(RoadLeg.class.getClassLoader());
        this.mRouteHigh = in.readArrayList(GeoPoint.class.getClassLoader());
        this.mBoundingBox = (BoundingBoxE6)in.readParcelable(BoundingBoxE6.class.getClassLoader());
    }

    /* synthetic */ Road(Parcel parcel, Road road) {
        this(parcel);
    }
}

