/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.http.NameValuePair;
import org.osmdroid.bonuspack.utils.HttpConnection;

public class BonusPackHelper {
    public static final String LOG_TAG = "BONUSPACK";
    public static final String DEFAULT_USER_AGENT = "OsmBonusPack/1";

    public static boolean isEmulator() {
        return "google_sdk".equals(Build.PRODUCT) || "sdk".equals(Build.PRODUCT);
    }

    private static String readStream(HttpConnection connection) {
        String result = connection.getContentAsString();
        return result;
    }

    public static String requestStringFromUrl(String url) {
        HttpConnection connection = new HttpConnection();
        connection.doGet(url);
        String result = BonusPackHelper.readStream(connection);
        connection.close();
        return result;
    }

    public static String requestStringFromPost(String url, List<NameValuePair> nameValuePairs) {
        HttpConnection connection = new HttpConnection();
        connection.doPost(url, nameValuePairs);
        String result = BonusPackHelper.readStream(connection);
        connection.close();
        return result;
    }

    public static Bitmap loadBitmap(String url) {
        InputStream is;
        Bitmap bitmap;
        block3: {
            bitmap = null;
            try {
                is = (InputStream)new URL(url).getContent();
                if (is != null) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        bitmap = BitmapFactory.decodeStream((InputStream)new FlushedInputStream(is));
        return bitmap;
    }

    static class FlushedInputStream
    extends FilterInputStream {
        public FlushedInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public long skip(long n) throws IOException {
            long totalBytesSkipped = 0L;
            while (totalBytesSkipped < n) {
                long bytesSkipped = this.in.skip(n - totalBytesSkipped);
                if (bytesSkipped == 0L) {
                    int byteValue = this.read();
                    if (byteValue < 0) break;
                    bytesSkipped = 1L;
                }
                totalBytesSkipped += bytesSkipped;
            }
            return totalBytesSkipped;
        }
    }
}

