/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.location;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.location.GeoNamesXMLHandler;
import org.osmdroid.bonuspack.location.POI;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.bonuspack.utils.HttpConnection;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GeoNamesPOIProvider {
    protected String mUserName;

    public GeoNamesPOIProvider(String account) {
        this.mUserName = account;
    }

    private String getUrlCloseTo(GeoPoint p, int maxResults, double maxDistance) {
        StringBuffer url = new StringBuffer("http://api.geonames.org/findNearbyWikipediaJSON?");
        url.append("lat=" + (double)p.getLatitudeE6() * 1.0E-6);
        url.append("&lng=" + (double)p.getLongitudeE6() * 1.0E-6);
        url.append("&maxRows=" + maxResults);
        url.append("&radius=" + maxDistance);
        url.append("&lang=" + Locale.getDefault().getLanguage());
        url.append("&username=" + this.mUserName);
        return url.toString();
    }

    private String getUrlInside(BoundingBoxE6 boundingBox, int maxResults) {
        StringBuffer url = new StringBuffer("http://api.geonames.org/wikipediaBoundingBoxJSON?");
        url.append("south=" + (double)boundingBox.getLatSouthE6() * 1.0E-6);
        url.append("&north=" + (double)boundingBox.getLatNorthE6() * 1.0E-6);
        url.append("&east=" + (double)boundingBox.getLonEastE6() * 1.0E-6);
        url.append("&west=" + (double)boundingBox.getLonWestE6() * 1.0E-6);
        url.append("&maxRows=" + maxResults);
        url.append("&lang=" + Locale.getDefault().getLanguage());
        url.append("&username=" + this.mUserName);
        return url.toString();
    }

    public ArrayList<POI> getThem(String fullUrl) {
        Log.d((String)"BONUSPACK", (String)("GeoNamesPOIProvider:get:" + fullUrl));
        String jString = BonusPackHelper.requestStringFromUrl(fullUrl);
        if (jString == null) {
            Log.e((String)"BONUSPACK", (String)"GeoNamesPOIProvider: request failed.");
            return null;
        }
        try {
            JSONObject jRoot = new JSONObject(jString);
            JSONArray jPlaceIds = jRoot.getJSONArray("geonames");
            int n = jPlaceIds.length();
            ArrayList<POI> pois = new ArrayList<POI>(n);
            int i = 0;
            while (i < n) {
                JSONObject jPlace = jPlaceIds.getJSONObject(i);
                POI poi = new POI(POI.POI_SERVICE_GEONAMES_WIKIPEDIA);
                poi.mLocation = new GeoPoint(jPlace.getDouble("lat"), jPlace.getDouble("lng"));
                poi.mCategory = jPlace.optString("feature");
                poi.mType = jPlace.getString("title");
                poi.mDescription = jPlace.optString("summary");
                poi.mThumbnailPath = jPlace.optString("thumbnailImg", null);
                poi.mUrl = jPlace.optString("wikipediaUrl", null);
                if (poi.mUrl != null) {
                    poi.mUrl = "http://" + poi.mUrl;
                }
                poi.mRank = jPlace.optInt("rank", 0);
                pois.add(poi);
                ++i;
            }
            Log.d((String)"BONUSPACK", (String)"done");
            return pois;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<POI> getThemXML(String fullUrl) {
        Log.d((String)"BONUSPACK", (String)("GeoNamesPOIProvider:get:" + fullUrl));
        HttpConnection connection = new HttpConnection();
        connection.doGet(fullUrl);
        InputStream stream = connection.getStream();
        if (stream == null) {
            return null;
        }
        GeoNamesXMLHandler handler = new GeoNamesXMLHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(stream, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        connection.close();
        Log.d((String)"BONUSPACK", (String)"done");
        return handler.mPOIs;
    }

    public ArrayList<POI> getPOICloseTo(GeoPoint position, int maxResults, double maxDistance) {
        String url = this.getUrlCloseTo(position, maxResults, maxDistance);
        return this.getThem(url);
    }

    public ArrayList<POI> getPOIInside(BoundingBoxE6 boundingBox, int maxResults) {
        String url = this.getUrlInside(boundingBox, maxResults);
        return this.getThem(url);
    }
}

