/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.location;

import android.content.Context;
import android.location.Address;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;

public class GeocoderNominatim {
    public static final String NOMINATIM_SERVICE_URL = "http://nominatim.openstreetmap.org/";
    public static final String MAPQUEST_SERVICE_URL = "http://open.mapquestapi.com/nominatim/v1/";
    protected Locale mLocale;
    protected String mServiceUrl;
    protected boolean mPolygon;

    protected void init(Context context, Locale locale) {
        this.mLocale = locale;
        this.setOptions(false);
        this.setService(NOMINATIM_SERVICE_URL);
    }

    public GeocoderNominatim(Context context, Locale locale) {
        this.init(context, locale);
    }

    public GeocoderNominatim(Context context) {
        this.init(context, Locale.getDefault());
    }

    public static boolean isPresent() {
        return true;
    }

    public void setService(String serviceUrl) {
        this.mServiceUrl = serviceUrl;
    }

    public void setOptions(boolean polygon) {
        this.mPolygon = polygon;
    }

    protected Address buildAndroidAddress(JSONObject jResult) throws JSONException {
        Address gAddress = new Address(this.mLocale);
        gAddress.setLatitude(jResult.getDouble("lat"));
        gAddress.setLongitude(jResult.getDouble("lon"));
        JSONObject jAddress = jResult.getJSONObject("address");
        int addressIndex = 0;
        if (jAddress.has("road")) {
            gAddress.setAddressLine(addressIndex++, jAddress.getString("road"));
            gAddress.setThoroughfare(jAddress.getString("road"));
        }
        if (jAddress.has("suburb")) {
            gAddress.setSubLocality(jAddress.getString("suburb"));
        }
        if (jAddress.has("postcode")) {
            gAddress.setAddressLine(addressIndex++, jAddress.getString("postcode"));
            gAddress.setPostalCode(jAddress.getString("postcode"));
        }
        if (jAddress.has("city")) {
            gAddress.setAddressLine(addressIndex++, jAddress.getString("city"));
            gAddress.setLocality(jAddress.getString("city"));
        } else if (jAddress.has("town")) {
            gAddress.setAddressLine(addressIndex++, jAddress.getString("town"));
            gAddress.setLocality(jAddress.getString("town"));
        } else if (jAddress.has("village")) {
            gAddress.setAddressLine(addressIndex++, jAddress.getString("village"));
            gAddress.setLocality(jAddress.getString("village"));
        }
        if (jAddress.has("county")) {
            gAddress.setSubAdminArea(jAddress.getString("county"));
        }
        if (jAddress.has("state")) {
            gAddress.setAdminArea(jAddress.getString("state"));
        }
        if (jAddress.has("country")) {
            gAddress.setAddressLine(addressIndex++, jAddress.getString("country"));
            gAddress.setCountryName(jAddress.getString("country"));
        }
        if (jAddress.has("country_code")) {
            gAddress.setCountryCode(jAddress.getString("country_code"));
        }
        Bundle extras = new Bundle();
        if (jResult.has("polygonpoints")) {
            JSONArray jPolygonPoints = jResult.getJSONArray("polygonpoints");
            ArrayList<GeoPoint> polygonPoints = new ArrayList<GeoPoint>(jPolygonPoints.length());
            int i = 0;
            while (i < jPolygonPoints.length()) {
                JSONArray jCoords = jPolygonPoints.getJSONArray(i);
                double lon = jCoords.getDouble(0);
                double lat = jCoords.getDouble(1);
                GeoPoint p = new GeoPoint(lat, lon);
                polygonPoints.add(p);
                ++i;
            }
            extras.putParcelableArrayList("polygonpoints", polygonPoints);
        }
        if (jResult.has("boundingbox")) {
            JSONArray jBoundingBox = jResult.getJSONArray("boundingbox");
            BoundingBoxE6 bb = new BoundingBoxE6(jBoundingBox.getDouble(1), jBoundingBox.getDouble(2), jBoundingBox.getDouble(0), jBoundingBox.getDouble(3));
            extras.putParcelable("boundingbox", (Parcelable)bb);
        }
        if (jResult.has("osm_id")) {
            long osm_id = jResult.getLong("osm_id");
            extras.putLong("osm_id", osm_id);
        }
        if (jResult.has("osm_type")) {
            String osm_type = jResult.getString("osm_type");
            extras.putString("osm_type", osm_type);
        }
        gAddress.setExtras(extras);
        return gAddress;
    }

    public List<Address> getFromLocation(double latitude, double longitude, int maxResults) throws IOException {
        String url = String.valueOf(this.mServiceUrl) + "reverse?" + "format=json" + "&accept-language=" + this.mLocale.getLanguage() + "&lat=" + latitude + "&lon=" + longitude;
        Log.d((String)"BONUSPACK", (String)("GeocoderNominatim::getFromLocation:" + url));
        String result = BonusPackHelper.requestStringFromUrl(url);
        if (result == null) {
            throw new IOException();
        }
        try {
            JSONObject jResult = new JSONObject(result);
            Address gAddress = this.buildAndroidAddress(jResult);
            ArrayList<Address> list = new ArrayList<Address>();
            list.add(gAddress);
            return list;
        }
        catch (JSONException e) {
            throw new IOException();
        }
    }

    public List<Address> getFromLocationName(String locationName, int maxResults, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude) throws IOException {
        String url = String.valueOf(this.mServiceUrl) + "search?" + "format=json" + "&accept-language=" + this.mLocale.getLanguage() + "&addressdetails=1" + "&limit=" + maxResults + "&q=" + URLEncoder.encode(locationName);
        if (lowerLeftLatitude != 0.0 && lowerLeftLongitude != 0.0) {
            url = String.valueOf(url) + "&viewbox=" + lowerLeftLongitude + "," + upperRightLatitude + "," + upperRightLongitude + "," + lowerLeftLatitude + "&bounded=1";
        }
        if (this.mPolygon) {
            url = String.valueOf(url) + "&polygon=1";
        }
        Log.d((String)"BONUSPACK", (String)("GeocoderNominatim::getFromLocationName:" + url));
        String result = BonusPackHelper.requestStringFromUrl(url);
        if (result == null) {
            throw new IOException();
        }
        try {
            JSONArray jResults = new JSONArray(result);
            ArrayList<Address> list = new ArrayList<Address>();
            int i = 0;
            while (i < jResults.length()) {
                JSONObject jResult = jResults.getJSONObject(i);
                Address gAddress = this.buildAndroidAddress(jResult);
                list.add(gAddress);
                ++i;
            }
            return list;
        }
        catch (JSONException e) {
            throw new IOException();
        }
    }

    public List<Address> getFromLocationName(String locationName, int maxResults) throws IOException {
        return this.getFromLocationName(locationName, maxResults, 0.0, 0.0, 0.0, 0.0);
    }
}

