/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.location;

import android.graphics.Bitmap;
import android.util.Log;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.location.POI;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;

public class NominatimPOIProvider {
    public static final String MAPQUEST_POI_SERVICE = "http://open.mapquestapi.com/nominatim/v1/";
    public static final String NOMINATIM_POI_SERVICE = "http://nominatim.openstreetmap.org/";
    protected String mService = "http://nominatim.openstreetmap.org/";

    public void setService(String serviceUrl) {
        this.mService = serviceUrl;
    }

    private StringBuffer getCommonUrl(String facility, int maxResults) {
        StringBuffer urlString = new StringBuffer(this.mService);
        urlString.append("search?");
        urlString.append("format=json");
        urlString.append("&q=[" + URLEncoder.encode(facility) + "]");
        urlString.append("&limit=" + maxResults);
        urlString.append("&bounded=1");
        return urlString;
    }

    private String getUrlInside(BoundingBoxE6 bb, String type, int maxResults) {
        StringBuffer urlString = this.getCommonUrl(type, maxResults);
        urlString.append("&viewbox=" + (double)bb.getLonWestE6() * 1.0E-6 + "," + (double)bb.getLatNorthE6() * 1.0E-6 + "," + (double)bb.getLonEastE6() * 1.0E-6 + "," + (double)bb.getLatSouthE6() * 1.0E-6);
        return urlString.toString();
    }

    private String getUrlCloseTo(GeoPoint p, String type, int maxResults, double maxDistance) {
        int maxD = (int)(maxDistance * 1000000.0);
        BoundingBoxE6 bb = new BoundingBoxE6(p.getLatitudeE6() + maxD, p.getLongitudeE6() + maxD, p.getLatitudeE6() - maxD, p.getLongitudeE6() - maxD);
        return this.getUrlInside(bb, type, maxResults);
    }

    public ArrayList<POI> getThem(String url) {
        Log.d((String)"BONUSPACK", (String)("NominatimPOIProvider:get:" + url));
        String jString = BonusPackHelper.requestStringFromUrl(url);
        if (jString == null) {
            Log.e((String)"BONUSPACK", (String)"NominatimPOIProvider: request failed.");
            return null;
        }
        try {
            JSONArray jPlaceIds = new JSONArray(jString);
            int n = jPlaceIds.length();
            ArrayList<POI> pois = new ArrayList<POI>(n);
            Bitmap thumbnail = null;
            int i = 0;
            while (i < n) {
                JSONObject jPlace = jPlaceIds.getJSONObject(i);
                POI poi = new POI(POI.POI_SERVICE_NOMINATIM);
                poi.mId = jPlace.optLong("osm_id");
                poi.mLocation = new GeoPoint(jPlace.getDouble("lat"), jPlace.getDouble("lon"));
                poi.mCategory = jPlace.optString("class");
                poi.mType = jPlace.getString("type");
                poi.mDescription = jPlace.optString("display_name");
                poi.mThumbnailPath = jPlace.optString("icon", null);
                if (i == 0 && poi.mThumbnailPath != null) {
                    thumbnail = BonusPackHelper.loadBitmap(poi.mThumbnailPath);
                }
                poi.mThumbnail = thumbnail;
                pois.add(poi);
                ++i;
            }
            return pois;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<POI> getPOICloseTo(GeoPoint position, String facility, int maxResults, double maxDistance) {
        String url = this.getUrlCloseTo(position, facility, maxResults, maxDistance);
        return this.getThem(url);
    }

    public ArrayList<POI> getPOIInside(BoundingBoxE6 boundingBox, String facility, int maxResults) {
        String url = this.getUrlInside(boundingBox, facility, maxResults);
        return this.getThem(url);
    }

    public ArrayList<POI> getPOIAlong(ArrayList<GeoPoint> path, String facility, int maxResults, double maxWidth) {
        StringBuffer url = this.getCommonUrl(facility, maxResults);
        url.append("&routewidth=" + maxWidth);
        url.append("&route=");
        boolean isFirst = true;
        for (GeoPoint p : path) {
            if (isFirst) {
                isFirst = false;
            } else {
                url.append(",");
            }
            String lat = Double.toString((double)p.getLatitudeE6() * 1.0E-6);
            lat = lat.substring(0, Math.min(lat.length(), 7));
            String lon = Double.toString((double)p.getLongitudeE6() * 1.0E-6);
            lon = lon.substring(0, Math.min(lon.length(), 7));
            url.append(String.valueOf(lat) + "," + lon);
        }
        return this.getThem(url.toString());
    }
}

