/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.overlays;

import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.bonuspack.overlays.InfoWindow;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.OverlayItem;

public class ExtendedOverlayItem
extends OverlayItem {
    private String mTitle;
    private String mDescription;
    private String mSubDescription;
    private Drawable mImage;
    private Object mRelatedObject;

    public ExtendedOverlayItem(String aTitle, String aDescription, GeoPoint aGeoPoint, Context context) {
        super(aTitle, aDescription, aGeoPoint);
        this.mTitle = aTitle;
        this.mDescription = aDescription;
        this.mSubDescription = null;
        this.mImage = null;
        this.mRelatedObject = null;
    }

    public void setTitle(String aTitle) {
        this.mTitle = aTitle;
    }

    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    public void setSubDescription(String aSubDescription) {
        this.mSubDescription = aSubDescription;
    }

    public void setImage(Drawable anImage) {
        this.mImage = anImage;
    }

    public void setRelatedObject(Object o) {
        this.mRelatedObject = o;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getSubDescription() {
        return this.mSubDescription;
    }

    public Drawable getImage() {
        return this.mImage;
    }

    public Object getRelatedObject() {
        return this.mRelatedObject;
    }

    public Point getHotspot(OverlayItem.HotspotPlace place, int w, int h) {
        Point hp = new Point();
        if (place == null) {
            place = OverlayItem.HotspotPlace.BOTTOM_CENTER;
        }
        switch (place) {
            case NONE: {
                hp.set(0, 0);
                break;
            }
            case BOTTOM_CENTER: {
                hp.set(w / 2, 0);
                break;
            }
            case LOWER_LEFT_CORNER: {
                hp.set(0, 0);
                break;
            }
            case LOWER_RIGHT_CORNER: {
                hp.set(w, 0);
                break;
            }
            case CENTER: {
                hp.set(w / 2, -h / 2);
                break;
            }
            case LEFT_CENTER: {
                hp.set(0, -h / 2);
                break;
            }
            case RIGHT_CENTER: {
                hp.set(w, -h / 2);
                break;
            }
            case TOP_CENTER: {
                hp.set(w / 2, -h);
                break;
            }
            case UPPER_LEFT_CORNER: {
                hp.set(0, -h);
                break;
            }
            case UPPER_RIGHT_CORNER: {
                hp.set(w, -h);
            }
        }
        return hp;
    }

    public void showBubble(InfoWindow bubble, MapView mapView, boolean panIntoView) {
        Drawable marker = this.getMarker(0);
        int markerWidth = 0;
        int markerHeight = 0;
        if (marker != null) {
            markerWidth = marker.getIntrinsicWidth();
            markerHeight = marker.getIntrinsicHeight();
        }
        Point markerH = this.getHotspot(this.getMarkerHotspot(), markerWidth, markerHeight);
        Point bubbleH = this.getHotspot(OverlayItem.HotspotPlace.TOP_CENTER, markerWidth, markerHeight);
        bubbleH.offset(-markerH.x, -markerH.y);
        bubble.open(this, bubbleH.x, bubbleH.y);
        if (panIntoView) {
            mapView.getController().animateTo((IGeoPoint)this.getPoint());
        }
    }
}

