/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.overlays;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import org.osmdroid.api.IGeoPoint;
import org.osmdroid.bonuspack.overlays.ExtendedOverlayItem;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;

public abstract class InfoWindow {
    protected View mView;
    protected boolean mIsVisible = false;
    protected MapView mMapView;

    public InfoWindow(int layoutResId, MapView mapView) {
        this.mMapView = mapView;
        this.mIsVisible = false;
        ViewGroup parent = (ViewGroup)mapView.getParent();
        Context context = mapView.getContext();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mView = inflater.inflate(layoutResId, parent, false);
    }

    public View getView() {
        return this.mView;
    }

    public void open(ExtendedOverlayItem item, int offsetX, int offsetY) {
        this.onOpen(item);
        GeoPoint position = item.getPoint();
        MapView.LayoutParams lp = new MapView.LayoutParams(-2, -2, (IGeoPoint)position, 8, offsetX, offsetY);
        this.close();
        this.mMapView.addView(this.mView, (ViewGroup.LayoutParams)lp);
        this.mIsVisible = true;
    }

    public void close() {
        if (this.mIsVisible) {
            this.mIsVisible = false;
            ((ViewGroup)this.mView.getParent()).removeView(this.mView);
            this.onClose();
        }
    }

    public boolean isOpen() {
        return this.mIsVisible;
    }

    public abstract void onOpen(ExtendedOverlayItem var1);

    public abstract void onClose();
}

