/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import java.util.ArrayList;
import org.osmdroid.bonuspack.routing.Road;
import org.osmdroid.bonuspack.routing.RoadLeg;
import org.osmdroid.bonuspack.routing.RoadNode;
import org.osmdroid.bonuspack.utils.PolylineEncoder;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class GoogleDirectionsHandler
extends DefaultHandler {
    Road mRoad = new Road();
    RoadLeg mLeg;
    RoadNode mNode;
    boolean isPolyline = false;
    boolean isOverviewPolyline = false;
    boolean isLeg = false;
    boolean isStep = false;
    boolean isDuration = false;
    boolean isDistance = false;
    boolean isBB = false;
    int mValue;
    double mLat;
    double mLng;
    double mNorth;
    double mWest;
    double mSouth;
    double mEast;
    private String mString;

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (localName.equals("polyline")) {
            this.isPolyline = true;
        } else if (localName.equals("overview_polyline")) {
            this.isOverviewPolyline = true;
        } else if (localName.equals("leg")) {
            this.mLeg = new RoadLeg();
            this.isLeg = true;
        } else if (localName.equals("step")) {
            this.mNode = new RoadNode();
            this.isStep = true;
        } else if (localName.equals("duration")) {
            this.isDuration = true;
        } else if (localName.equals("distance")) {
            this.isDistance = true;
        } else if (localName.equals("bounds")) {
            this.isBB = true;
        }
        this.mString = new String();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        this.mString = this.mString.concat(chars);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (localName.equals("points")) {
            if (this.isPolyline) {
                ArrayList<GeoPoint> polyLine = PolylineEncoder.decode(this.mString, 10);
                this.mRoad.mRouteHigh.addAll(polyLine);
            } else if (this.isOverviewPolyline) {
                this.mRoad.setRouteLow(PolylineEncoder.decode(this.mString, 10));
            }
        } else if (localName.equals("polyline")) {
            this.isPolyline = false;
        } else if (localName.equals("overview_polyline")) {
            this.isOverviewPolyline = false;
        } else if (localName.equals("value")) {
            this.mValue = Integer.parseInt(this.mString);
        } else if (localName.equals("duration")) {
            if (this.isStep) {
                this.mNode.mDuration = this.mValue;
            } else {
                this.mLeg.mDuration = this.mValue;
            }
            this.isDuration = false;
        } else if (localName.equals("distance")) {
            if (this.isStep) {
                this.mNode.mLength = (double)this.mValue / 1000.0;
            } else {
                this.mLeg.mLength = (double)this.mValue / 1000.0;
            }
            this.isDistance = false;
        } else if (localName.equals("html_instructions")) {
            if (this.isStep) {
                this.mString = this.mString.replaceAll("<[^>]*>", " ");
                this.mNode.mInstructions = this.mString = this.mString.replaceAll("&nbsp;", " ");
            }
        } else if (localName.equals("start_location")) {
            if (this.isStep) {
                this.mNode.mLocation = new GeoPoint(this.mLat, this.mLng);
            }
        } else if (localName.equals("step")) {
            this.mRoad.mNodes.add(this.mNode);
            this.isStep = false;
        } else if (localName.equals("leg")) {
            this.mRoad.mLegs.add(this.mLeg);
            this.isLeg = false;
        } else if (localName.equals("lat")) {
            this.mLat = Double.parseDouble(this.mString);
        } else if (localName.equals("lng")) {
            this.mLng = Double.parseDouble(this.mString);
        } else if (localName.equals("northeast")) {
            if (this.isBB) {
                this.mNorth = this.mLat;
                this.mEast = this.mLng;
            }
        } else if (localName.equals("southwest")) {
            if (this.isBB) {
                this.mSouth = this.mLat;
                this.mWest = this.mLng;
            }
        } else if (localName.equals("bounds")) {
            this.mRoad.mBoundingBox = new BoundingBoxE6(this.mNorth, this.mEast, this.mSouth, this.mWest);
            this.isBB = false;
        }
    }
}

