/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osmdroid.bonuspack.routing.GoogleDirectionsHandler;
import org.osmdroid.bonuspack.routing.Road;
import org.osmdroid.bonuspack.routing.RoadLeg;
import org.osmdroid.bonuspack.routing.RoadManager;
import org.osmdroid.bonuspack.utils.HttpConnection;
import org.osmdroid.util.GeoPoint;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GoogleRoadManager
extends RoadManager {
    static final String GOOGLE_DIRECTIONS_SERVICE = "http://maps.googleapis.com/maps/api/directions/xml?";

    protected String getUrl(ArrayList<GeoPoint> waypoints) {
        StringBuffer urlString = new StringBuffer(GOOGLE_DIRECTIONS_SERVICE);
        urlString.append("origin=");
        GeoPoint p = waypoints.get(0);
        urlString.append(this.geoPointAsString(p));
        urlString.append("&destination=");
        int destinationIndex = waypoints.size() - 1;
        p = waypoints.get(destinationIndex);
        urlString.append(this.geoPointAsString(p));
        int i = 1;
        while (i < destinationIndex) {
            if (i == 1) {
                urlString.append("&waypoints=");
            } else {
                urlString.append("%7C");
            }
            p = waypoints.get(i);
            urlString.append(this.geoPointAsString(p));
            ++i;
        }
        urlString.append("&units=metric&sensor=false");
        Locale locale = Locale.getDefault();
        urlString.append("&language=" + locale.getLanguage());
        urlString.append(this.mOptions);
        return urlString.toString();
    }

    @Override
    public Road getRoad(ArrayList<GeoPoint> waypoints) {
        String url = this.getUrl(waypoints);
        Log.d((String)"BONUSPACK", (String)("GoogleRoadManager.getRoad:" + url));
        Road road = null;
        HttpConnection connection = new HttpConnection();
        connection.doGet(url);
        InputStream stream = connection.getStream();
        if (stream != null) {
            road = this.getRoadXML(stream);
        }
        connection.close();
        if (road == null || road.mRouteHigh.size() == 0) {
            road = new Road(waypoints);
        } else {
            for (RoadLeg leg : road.mLegs) {
                road.mDuration += leg.mDuration;
                road.mLength += leg.mLength;
            }
            road.mStatus = 1;
        }
        Log.d((String)"BONUSPACK", (String)"GoogleRoadManager.getRoad - finished");
        return road;
    }

    protected Road getRoadXML(InputStream is) {
        GoogleDirectionsHandler handler = new GoogleDirectionsHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return handler.mRoad;
    }
}

