/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osmdroid.bonuspack.routing.Road;
import org.osmdroid.bonuspack.routing.RoadLink;
import org.osmdroid.bonuspack.routing.RoadManager;
import org.osmdroid.bonuspack.routing.RoadNode;
import org.osmdroid.bonuspack.routing.XMLHandler;
import org.osmdroid.bonuspack.utils.HttpConnection;
import org.osmdroid.util.GeoPoint;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MapQuestRoadManager
extends RoadManager {
    static final String MAPQUEST_GUIDANCE_SERVICE = "http://open.mapquestapi.com/guidance/v0/route?";

    protected String getUrl(ArrayList<GeoPoint> waypoints) {
        StringBuffer urlString = new StringBuffer(MAPQUEST_GUIDANCE_SERVICE);
        urlString.append("from=");
        GeoPoint p = waypoints.get(0);
        urlString.append(this.geoPointAsString(p));
        int i = 1;
        while (i < waypoints.size()) {
            p = waypoints.get(i);
            urlString.append("&to=" + this.geoPointAsString(p));
            ++i;
        }
        urlString.append("&outFormat=xml");
        urlString.append("&shapeFormat=cmp");
        urlString.append("&narrativeType=text");
        urlString.append("&unit=k&fishbone=false");
        urlString.append(this.mOptions);
        return urlString.toString();
    }

    @Override
    public Road getRoad(ArrayList<GeoPoint> waypoints) {
        String url = this.getUrl(waypoints);
        Log.d((String)"BONUSPACK", (String)("MapQuestRoadManager.getRoute:" + url));
        Road road = null;
        HttpConnection connection = new HttpConnection();
        connection.doGet(url);
        InputStream stream = connection.getStream();
        if (stream != null) {
            road = this.getRoadXML(stream, waypoints);
        }
        if (road == null || road.mRouteHigh.size() == 0) {
            road = new Road(waypoints);
        }
        connection.close();
        Log.d((String)"BONUSPACK", (String)"MapQuestRoadManager.getRoute - finished");
        return road;
    }

    protected Road getRoadXML(InputStream is, ArrayList<GeoPoint> waypoints) {
        XMLHandler handler = new XMLHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Road road = handler.mRoad;
        if (road != null && road.mRouteHigh.size() > 0) {
            road.mNodes = this.finalizeNodes(road.mNodes, handler.mLinks, road.mRouteHigh);
            road.mRouteHigh = this.finalizeRoadShape(road, handler.mLinks);
            road.buildLegs(waypoints);
            road.mStatus = 1;
        }
        return road;
    }

    protected ArrayList<RoadNode> finalizeNodes(ArrayList<RoadNode> mNodes, ArrayList<RoadLink> mLinks, ArrayList<GeoPoint> polyline) {
        int n = mNodes.size();
        if (n == 0) {
            return mNodes;
        }
        ArrayList<RoadNode> newNodes = new ArrayList<RoadNode>(n);
        RoadNode lastNode = null;
        int i = 1;
        while (i < n - 1) {
            RoadNode node = mNodes.get(i);
            RoadLink link = mLinks.get(node.mNextRoadLink);
            if (lastNode != null && (node.mInstructions == null || node.mManeuverType == 0)) {
                lastNode.mLength += link.mLength;
                lastNode.mDuration += node.mDuration + link.mDuration;
            } else {
                node.mLength = link.mLength;
                node.mDuration += link.mDuration;
                int locationIndex = link.mShapeIndex;
                node.mLocation = polyline.get(locationIndex);
                newNodes.add(node);
                lastNode = node;
            }
            ++i;
        }
        return newNodes;
    }

    public ArrayList<GeoPoint> finalizeRoadShape(Road road, ArrayList<RoadLink> links) {
        ArrayList<GeoPoint> newShape = new ArrayList<GeoPoint>(road.mRouteHigh.size());
        RoadNode nodeStart = road.mNodes.get(0);
        RoadNode nodeEnd = road.mNodes.get(road.mNodes.size() - 1);
        int shapeIndexStart = links.get((int)nodeStart.mNextRoadLink).mShapeIndex;
        int shapeIndexEnd = links.get((int)nodeEnd.mNextRoadLink).mShapeIndex;
        int i = shapeIndexStart;
        while (i <= shapeIndexEnd) {
            newShape.add(road.mRouteHigh.get(i));
            ++i;
        }
        return newShape;
    }
}

