/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import android.content.Context;
import android.graphics.Paint;
import java.util.ArrayList;
import org.osmdroid.bonuspack.routing.Road;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.overlay.PathOverlay;

public abstract class RoadManager {
    protected String mOptions = "";

    public abstract Road getRoad(ArrayList<GeoPoint> var1);

    public void addRequestOption(String requestOption) {
        this.mOptions = String.valueOf(this.mOptions) + "&" + requestOption;
    }

    protected String geoPointAsString(GeoPoint p) {
        StringBuffer result = new StringBuffer();
        double d = (double)p.getLatitudeE6() * 1.0E-6;
        result.append(Double.toString(d));
        d = (double)p.getLongitudeE6() * 1.0E-6;
        result.append("," + Double.toString(d));
        return result.toString();
    }

    public static PathOverlay buildRoadOverlay(Road road, Paint paint, Context context) {
        PathOverlay roadOverlay = new PathOverlay(0, context);
        roadOverlay.setPaint(paint);
        if (road != null) {
            ArrayList<GeoPoint> polyline = road.mRouteHigh;
            for (GeoPoint p : polyline) {
                roadOverlay.addPoint(p);
            }
        }
        return roadOverlay;
    }

    public static PathOverlay buildRoadOverlay(Road road, Context context) {
        Paint paint = new Paint();
        paint.setColor(-2147483393);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(5.0f);
        return RoadManager.buildRoadOverlay(road, paint, context);
    }
}

