/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.tlv;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.ListView;
import com.commonsware.cwac.tlv.R;

public class TouchListView
extends ListView {
    private ImageView mDragView;
    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mWindowParams;
    private int mDragPos;
    private int mFirstDragPos;
    private int mDragPoint;
    private int mCoordOffset;
    private DragListener mDragListener;
    private DropListener mDropListener;
    private RemoveListener mRemoveListener;
    private int mUpperBound;
    private int mLowerBound;
    private int mHeight;
    private GestureDetector mGestureDetector;
    public static final int FLING = 0;
    public static final int SLIDE_RIGHT = 1;
    public static final int SLIDE_LEFT = 2;
    private int mRemoveMode = -1;
    private Rect mTempRect = new Rect();
    private Bitmap mDragBitmap;
    private final int mTouchSlop;
    private int mItemHeightNormal = -1;
    private int mItemHeightExpanded = -1;
    private int grabberId = -1;
    private int dragndropBackgroundColor = 0;

    public TouchListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TouchListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.TouchListView, 0, 0);
            this.mItemHeightNormal = a.getDimensionPixelSize(0, 0);
            this.mItemHeightExpanded = a.getDimensionPixelSize(1, this.mItemHeightNormal);
            this.grabberId = a.getResourceId(2, -1);
            this.dragndropBackgroundColor = a.getColor(3, 0);
            this.mRemoveMode = a.getInt(4, -1);
            a.recycle();
        }
    }

    public final void addHeaderView(View v, Object data, boolean isSelectable) {
        throw new RuntimeException("Headers are not supported with TouchListView");
    }

    public final void addHeaderView(View v) {
        throw new RuntimeException("Headers are not supported with TouchListView");
    }

    public final void addFooterView(View v, Object data, boolean isSelectable) {
        if (this.mRemoveMode == 2 || this.mRemoveMode == 1) {
            throw new RuntimeException("Footers are not supported with TouchListView in conjunction with remove_mode");
        }
    }

    public final void addFooterView(View v) {
        if (this.mRemoveMode == 2 || this.mRemoveMode == 1) {
            throw new RuntimeException("Footers are not supported with TouchListView in conjunction with remove_mode");
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mRemoveListener != null && this.mGestureDetector == null && this.mRemoveMode == 0) {
            this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                    if (TouchListView.this.mDragView != null) {
                        if (velocityX > 1000.0f) {
                            Rect r = TouchListView.this.mTempRect;
                            TouchListView.this.mDragView.getDrawingRect(r);
                            if (e2.getX() > (float)(r.right * 2 / 3)) {
                                TouchListView.this.stopDragging();
                                TouchListView.this.mRemoveListener.remove(TouchListView.this.mFirstDragPos);
                                TouchListView.this.unExpandViews(true);
                            }
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        if (this.mDragListener != null || this.mDropListener != null) {
            switch (ev.getAction()) {
                case 0: {
                    View item;
                    int x = (int)ev.getX();
                    int y = (int)ev.getY();
                    int itemnum = this.pointToPosition(x, y);
                    if (itemnum == -1 || !this.isDraggableRow(item = this.getChildAt(itemnum - this.getFirstVisiblePosition()))) break;
                    this.mDragPoint = y - item.getTop();
                    this.mCoordOffset = (int)ev.getRawY() - y;
                    View dragger = item.findViewById(this.grabberId);
                    Rect r = this.mTempRect;
                    r.left = dragger.getLeft();
                    r.right = dragger.getRight();
                    r.top = dragger.getTop();
                    r.bottom = dragger.getBottom();
                    if (r.left < x && x < r.right) {
                        item.setDrawingCacheEnabled(true);
                        Bitmap bitmap = Bitmap.createBitmap((Bitmap)item.getDrawingCache());
                        item.setDrawingCacheEnabled(false);
                        Rect listBounds = new Rect();
                        this.getGlobalVisibleRect(listBounds, null);
                        this.startDragging(bitmap, listBounds.left, y);
                        this.mFirstDragPos = this.mDragPos = itemnum;
                        this.mHeight = this.getHeight();
                        int touchSlop = this.mTouchSlop;
                        this.mUpperBound = Math.min(y - touchSlop, this.mHeight / 3);
                        this.mLowerBound = Math.max(y + touchSlop, this.mHeight * 2 / 3);
                        return false;
                    }
                    this.mDragView = null;
                }
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    protected boolean isDraggableRow(View view) {
        return view.findViewById(this.grabberId) != null;
    }

    private int myPointToPosition(int x, int y) {
        Rect frame = this.mTempRect;
        int count = this.getChildCount();
        int i = count - 1;
        while (i >= 0) {
            View child = this.getChildAt(i);
            child.getHitRect(frame);
            if (frame.contains(x, y)) {
                return this.getFirstVisiblePosition() + i;
            }
            --i;
        }
        return -1;
    }

    private int getItemForPosition(int y) {
        int adjustedy = y - this.mDragPoint - this.mItemHeightNormal / 2;
        int pos = this.myPointToPosition(0, adjustedy);
        if (pos >= 0) {
            if (pos <= this.mFirstDragPos) {
                ++pos;
            }
        } else if (adjustedy < 0) {
            pos = 0;
        }
        return pos;
    }

    private void adjustScrollBounds(int y) {
        if (y >= this.mHeight / 3) {
            this.mUpperBound = this.mHeight / 3;
        }
        if (y <= this.mHeight * 2 / 3) {
            this.mLowerBound = this.mHeight * 2 / 3;
        }
    }

    private void unExpandViews(boolean deletion) {
        int i = 0;
        while (true) {
            View v;
            if ((v = this.getChildAt(i)) == null) {
                if (deletion) {
                    int position = this.getFirstVisiblePosition();
                    int y = this.getChildAt(0).getTop();
                    this.setAdapter(this.getAdapter());
                    this.setSelectionFromTop(position, y);
                }
                this.layoutChildren();
                v = this.getChildAt(i);
                if (v == null) break;
            }
            if (this.isDraggableRow(v)) {
                ViewGroup.LayoutParams params = v.getLayoutParams();
                params.height = this.mItemHeightNormal;
                v.setLayoutParams(params);
                v.setVisibility(0);
            }
            ++i;
        }
    }

    private void doExpansion() {
        View vv;
        int childnum = this.mDragPos - this.getFirstVisiblePosition();
        if (this.mDragPos > this.mFirstDragPos) {
            ++childnum;
        }
        View first = this.getChildAt(this.mFirstDragPos - this.getFirstVisiblePosition());
        int i = 0;
        while ((vv = this.getChildAt(i)) != null) {
            int height = this.mItemHeightNormal;
            int visibility = 0;
            if (vv.equals(first)) {
                if (this.mDragPos == this.mFirstDragPos) {
                    visibility = 4;
                } else {
                    height = 1;
                }
            } else if (i == childnum && this.mDragPos < this.getCount() - 1) {
                height = this.mItemHeightExpanded;
            }
            if (this.isDraggableRow(vv)) {
                ViewGroup.LayoutParams params = vv.getLayoutParams();
                params.height = height;
                vv.setLayoutParams(params);
                vv.setVisibility(visibility);
            }
            ++i;
        }
        this.layoutChildren();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mGestureDetector != null) {
            this.mGestureDetector.onTouchEvent(ev);
        }
        if ((this.mDragListener != null || this.mDropListener != null) && this.mDragView != null) {
            int action = ev.getAction();
            switch (action) {
                case 1: 
                case 3: {
                    Rect r = this.mTempRect;
                    this.mDragView.getDrawingRect(r);
                    this.stopDragging();
                    if (this.mRemoveMode == 1 && ev.getX() > (float)(r.left + r.width() * 3 / 4)) {
                        if (this.mRemoveListener != null) {
                            this.mRemoveListener.remove(this.mFirstDragPos);
                        }
                        this.unExpandViews(true);
                        break;
                    }
                    if (this.mRemoveMode == 2 && ev.getX() < (float)(r.left + r.width() / 4)) {
                        if (this.mRemoveListener != null) {
                            this.mRemoveListener.remove(this.mFirstDragPos);
                        }
                        this.unExpandViews(true);
                        break;
                    }
                    if (this.mDropListener != null && this.mDragPos >= 0 && this.mDragPos < this.getCount()) {
                        this.mDropListener.drop(this.mFirstDragPos, this.mDragPos);
                    }
                    this.unExpandViews(false);
                    break;
                }
                case 0: 
                case 2: {
                    View v;
                    int x = (int)ev.getX();
                    int y = (int)ev.getY();
                    this.dragView(x, y);
                    int itemnum = this.getItemForPosition(y);
                    if (itemnum < 0) break;
                    if (action == 0 || itemnum != this.mDragPos) {
                        if (this.mDragListener != null) {
                            this.mDragListener.drag(this.mDragPos, itemnum);
                        }
                        this.mDragPos = itemnum;
                        this.doExpansion();
                    }
                    int speed = 0;
                    this.adjustScrollBounds(y);
                    if (y > this.mLowerBound) {
                        speed = y > (this.mHeight + this.mLowerBound) / 2 ? 16 : 4;
                    } else if (y < this.mUpperBound) {
                        int n = speed = y < this.mUpperBound / 2 ? -16 : -4;
                    }
                    if (speed == 0) break;
                    int ref = this.pointToPosition(0, this.mHeight / 2);
                    if (ref == -1) {
                        ref = this.pointToPosition(0, this.mHeight / 2 + this.getDividerHeight() + 64);
                    }
                    if ((v = this.getChildAt(ref - this.getFirstVisiblePosition())) == null) break;
                    int pos = v.getTop();
                    this.setSelectionFromTop(ref, pos - speed);
                }
            }
            return true;
        }
        return super.onTouchEvent(ev);
    }

    private void startDragging(Bitmap bm, int x, int y) {
        this.stopDragging();
        this.mWindowParams = new WindowManager.LayoutParams();
        this.mWindowParams.gravity = 51;
        this.mWindowParams.x = x;
        this.mWindowParams.y = y - this.mDragPoint + this.mCoordOffset;
        this.mWindowParams.height = -2;
        this.mWindowParams.width = -2;
        this.mWindowParams.flags = 408;
        this.mWindowParams.format = -3;
        this.mWindowParams.windowAnimations = 0;
        ImageView v = new ImageView(this.getContext());
        v.setBackgroundColor(this.dragndropBackgroundColor);
        v.setImageBitmap(bm);
        this.mDragBitmap = bm;
        this.mWindowManager = (WindowManager)this.getContext().getSystemService("window");
        this.mWindowManager.addView((View)v, (ViewGroup.LayoutParams)this.mWindowParams);
        this.mDragView = v;
    }

    private void dragView(int x, int y) {
        float alpha = 1.0f;
        int width = this.mDragView.getWidth();
        if (this.mRemoveMode == 1) {
            if (x > width / 2) {
                alpha = (float)(width - x) / (float)(width / 2);
            }
            this.mWindowParams.alpha = alpha;
        } else if (this.mRemoveMode == 2) {
            if (x < width / 2) {
                alpha = (float)x / (float)(width / 2);
            }
            this.mWindowParams.alpha = alpha;
        }
        this.mWindowParams.y = y - this.mDragPoint + this.mCoordOffset;
        this.mWindowManager.updateViewLayout((View)this.mDragView, (ViewGroup.LayoutParams)this.mWindowParams);
    }

    private void stopDragging() {
        if (this.mDragView != null) {
            WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
            wm.removeView((View)this.mDragView);
            this.mDragView.setImageDrawable(null);
            this.mDragView = null;
        }
        if (this.mDragBitmap != null) {
            this.mDragBitmap.recycle();
            this.mDragBitmap = null;
        }
    }

    public void setDragListener(DragListener l) {
        this.mDragListener = l;
    }

    public void setDropListener(DropListener l) {
        this.mDropListener = l;
    }

    public void setRemoveListener(RemoveListener l) {
        this.mRemoveListener = l;
    }

    public static interface DragListener {
        public void drag(int var1, int var2);
    }

    public static interface DropListener {
        public void drop(int var1, int var2);
    }

    public static interface RemoveListener {
        public void remove(int var1);
    }
}

