/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.nineoldandroids.animation;

import android.view.animation.Interpolator;
import com.actionbarsherlock.internal.nineoldandroids.animation.FloatKeyframeSet;
import com.actionbarsherlock.internal.nineoldandroids.animation.IntKeyframeSet;
import com.actionbarsherlock.internal.nineoldandroids.animation.Keyframe;
import com.actionbarsherlock.internal.nineoldandroids.animation.TypeEvaluator;
import java.util.ArrayList;
import java.util.Arrays;

class KeyframeSet {
    int mNumKeyframes;
    Keyframe mFirstKeyframe;
    Keyframe mLastKeyframe;
    Interpolator mInterpolator;
    ArrayList<Keyframe> mKeyframes;
    TypeEvaluator mEvaluator;

    public KeyframeSet(Keyframe ... keyframes) {
        this.mNumKeyframes = keyframes.length;
        this.mKeyframes = new ArrayList();
        this.mKeyframes.addAll(Arrays.asList(keyframes));
        this.mFirstKeyframe = this.mKeyframes.get(0);
        this.mLastKeyframe = this.mKeyframes.get(this.mNumKeyframes - 1);
        this.mInterpolator = this.mLastKeyframe.getInterpolator();
    }

    public static KeyframeSet ofInt(int ... values) {
        int numKeyframes = values.length;
        Keyframe.IntKeyframe[] keyframes = new Keyframe.IntKeyframe[Math.max(numKeyframes, 2)];
        if (numKeyframes == 1) {
            keyframes[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f);
            keyframes[1] = (Keyframe.IntKeyframe)Keyframe.ofInt(1.0f, values[0]);
        } else {
            keyframes[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f, values[0]);
            int i = 1;
            while (i < numKeyframes) {
                keyframes[i] = (Keyframe.IntKeyframe)Keyframe.ofInt((float)i / (float)(numKeyframes - 1), values[i]);
                ++i;
            }
        }
        return new IntKeyframeSet(keyframes);
    }

    public static KeyframeSet ofFloat(float ... values) {
        int numKeyframes = values.length;
        Keyframe.FloatKeyframe[] keyframes = new Keyframe.FloatKeyframe[Math.max(numKeyframes, 2)];
        if (numKeyframes == 1) {
            keyframes[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f);
            keyframes[1] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(1.0f, values[0]);
        } else {
            keyframes[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f, values[0]);
            int i = 1;
            while (i < numKeyframes) {
                keyframes[i] = (Keyframe.FloatKeyframe)Keyframe.ofFloat((float)i / (float)(numKeyframes - 1), values[i]);
                ++i;
            }
        }
        return new FloatKeyframeSet(keyframes);
    }

    public static KeyframeSet ofKeyframe(Keyframe ... keyframes) {
        int numKeyframes = keyframes.length;
        boolean hasFloat = false;
        boolean hasInt = false;
        boolean hasOther = false;
        int i = 0;
        while (i < numKeyframes) {
            if (keyframes[i] instanceof Keyframe.FloatKeyframe) {
                hasFloat = true;
            } else if (keyframes[i] instanceof Keyframe.IntKeyframe) {
                hasInt = true;
            } else {
                hasOther = true;
            }
            ++i;
        }
        if (hasFloat && !hasInt && !hasOther) {
            Keyframe.FloatKeyframe[] floatKeyframes = new Keyframe.FloatKeyframe[numKeyframes];
            int i2 = 0;
            while (i2 < numKeyframes) {
                floatKeyframes[i2] = (Keyframe.FloatKeyframe)keyframes[i2];
                ++i2;
            }
            return new FloatKeyframeSet(floatKeyframes);
        }
        if (hasInt && !hasFloat && !hasOther) {
            Keyframe.IntKeyframe[] intKeyframes = new Keyframe.IntKeyframe[numKeyframes];
            int i3 = 0;
            while (i3 < numKeyframes) {
                intKeyframes[i3] = (Keyframe.IntKeyframe)keyframes[i3];
                ++i3;
            }
            return new IntKeyframeSet(intKeyframes);
        }
        return new KeyframeSet(keyframes);
    }

    public static KeyframeSet ofObject(Object ... values) {
        int numKeyframes = values.length;
        Keyframe[] keyframes = new Keyframe.ObjectKeyframe[Math.max(numKeyframes, 2)];
        if (numKeyframes == 1) {
            keyframes[0] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(0.0f);
            keyframes[1] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(1.0f, values[0]);
        } else {
            keyframes[0] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(0.0f, values[0]);
            int i = 1;
            while (i < numKeyframes) {
                keyframes[i] = (Keyframe.ObjectKeyframe)Keyframe.ofObject((float)i / (float)(numKeyframes - 1), values[i]);
                ++i;
            }
        }
        return new KeyframeSet(keyframes);
    }

    public void setEvaluator(TypeEvaluator evaluator) {
        this.mEvaluator = evaluator;
    }

    public KeyframeSet clone() {
        ArrayList<Keyframe> keyframes = this.mKeyframes;
        int numKeyframes = this.mKeyframes.size();
        Keyframe[] newKeyframes = new Keyframe[numKeyframes];
        int i = 0;
        while (i < numKeyframes) {
            newKeyframes[i] = keyframes.get(i).clone();
            ++i;
        }
        KeyframeSet newSet = new KeyframeSet(newKeyframes);
        return newSet;
    }

    public Object getValue(float fraction) {
        if (this.mNumKeyframes == 2) {
            if (this.mInterpolator != null) {
                fraction = this.mInterpolator.getInterpolation(fraction);
            }
            return this.mEvaluator.evaluate(fraction, this.mFirstKeyframe.getValue(), this.mLastKeyframe.getValue());
        }
        if (fraction <= 0.0f) {
            Keyframe nextKeyframe = this.mKeyframes.get(1);
            Interpolator interpolator = nextKeyframe.getInterpolator();
            if (interpolator != null) {
                fraction = interpolator.getInterpolation(fraction);
            }
            float prevFraction = this.mFirstKeyframe.getFraction();
            float intervalFraction = (fraction - prevFraction) / (nextKeyframe.getFraction() - prevFraction);
            return this.mEvaluator.evaluate(intervalFraction, this.mFirstKeyframe.getValue(), nextKeyframe.getValue());
        }
        if (fraction >= 1.0f) {
            Keyframe prevKeyframe = this.mKeyframes.get(this.mNumKeyframes - 2);
            Interpolator interpolator = this.mLastKeyframe.getInterpolator();
            if (interpolator != null) {
                fraction = interpolator.getInterpolation(fraction);
            }
            float prevFraction = prevKeyframe.getFraction();
            float intervalFraction = (fraction - prevFraction) / (this.mLastKeyframe.getFraction() - prevFraction);
            return this.mEvaluator.evaluate(intervalFraction, prevKeyframe.getValue(), this.mLastKeyframe.getValue());
        }
        Keyframe prevKeyframe = this.mFirstKeyframe;
        int i = 1;
        while (i < this.mNumKeyframes) {
            Keyframe nextKeyframe = this.mKeyframes.get(i);
            if (fraction < nextKeyframe.getFraction()) {
                Interpolator interpolator = nextKeyframe.getInterpolator();
                if (interpolator != null) {
                    fraction = interpolator.getInterpolation(fraction);
                }
                float prevFraction = prevKeyframe.getFraction();
                float intervalFraction = (fraction - prevFraction) / (nextKeyframe.getFraction() - prevFraction);
                return this.mEvaluator.evaluate(intervalFraction, prevKeyframe.getValue(), nextKeyframe.getValue());
            }
            prevKeyframe = nextKeyframe;
            ++i;
        }
        return this.mLastKeyframe.getValue();
    }

    public String toString() {
        String returnVal = " ";
        int i = 0;
        while (i < this.mNumKeyframes) {
            returnVal = String.valueOf(returnVal) + this.mKeyframes.get(i).getValue() + "  ";
            ++i;
        }
        return returnVal;
    }
}

