/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.nineoldandroids.view.animation;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.os.Build;
import android.util.FloatMath;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public final class AnimatorProxy
extends Animation {
    public static final boolean NEEDS_PROXY = Build.VERSION.SDK_INT < 11;
    private static final WeakHashMap<View, AnimatorProxy> PROXIES = new WeakHashMap();
    private final WeakReference<View> mView;
    private float mAlpha = 1.0f;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;
    private float mTranslationX;
    private float mTranslationY;
    private final RectF mBefore = new RectF();
    private final RectF mAfter = new RectF();
    private final Matrix mTempMatrix = new Matrix();

    public static AnimatorProxy wrap(View view) {
        AnimatorProxy proxy = PROXIES.get(view);
        if (proxy == null) {
            proxy = new AnimatorProxy(view);
            PROXIES.put(view, proxy);
        }
        return proxy;
    }

    private AnimatorProxy(View view) {
        this.setDuration(0L);
        this.setFillAfter(true);
        view.setAnimation((Animation)this);
        this.mView = new WeakReference<View>(view);
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public void setAlpha(float alpha) {
        if (this.mAlpha != alpha) {
            this.mAlpha = alpha;
            View view = (View)this.mView.get();
            if (view != null) {
                view.invalidate();
            }
        }
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public void setScaleX(float scaleX) {
        if (this.mScaleX != scaleX) {
            this.prepareForUpdate();
            this.mScaleX = scaleX;
            this.invalidateAfterUpdate();
        }
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public void setScaleY(float scaleY) {
        if (this.mScaleY != scaleY) {
            this.prepareForUpdate();
            this.mScaleY = scaleY;
            this.invalidateAfterUpdate();
        }
    }

    public int getScrollX() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0;
        }
        return view.getScrollX();
    }

    public void setScrollX(int value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.scrollTo(value, view.getScrollY());
        }
    }

    public int getScrollY() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0;
        }
        return view.getScrollY();
    }

    public void setScrollY(int value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.scrollTo(view.getScrollY(), value);
        }
    }

    public float getTranslationX() {
        return this.mTranslationX;
    }

    public void setTranslationX(float translationX) {
        if (this.mTranslationX != translationX) {
            this.prepareForUpdate();
            this.mTranslationX = translationX;
            this.invalidateAfterUpdate();
        }
    }

    public float getTranslationY() {
        return this.mTranslationY;
    }

    public void setTranslationY(float translationY) {
        if (this.mTranslationY != translationY) {
            this.prepareForUpdate();
            this.mTranslationY = translationY;
            this.invalidateAfterUpdate();
        }
    }

    private void prepareForUpdate() {
        View view = (View)this.mView.get();
        if (view != null) {
            this.computeRect(this.mBefore, view);
        }
    }

    private void invalidateAfterUpdate() {
        View view = (View)this.mView.get();
        if (view == null) {
            return;
        }
        View parent = (View)view.getParent();
        if (parent == null) {
            return;
        }
        view.setAnimation((Animation)this);
        RectF after = this.mAfter;
        this.computeRect(after, view);
        after.union(this.mBefore);
        parent.invalidate((int)FloatMath.floor((float)after.left), (int)FloatMath.floor((float)after.top), (int)FloatMath.ceil((float)after.right), (int)FloatMath.ceil((float)after.bottom));
    }

    private void computeRect(RectF r, View view) {
        float f;
        float w = view.getWidth();
        float h = view.getHeight();
        r.set(0.0f, 0.0f, w, h);
        Matrix m = this.mTempMatrix;
        m.reset();
        this.transformMatrix(m, view);
        this.mTempMatrix.mapRect(r);
        r.offset((float)view.getLeft(), (float)view.getTop());
        if (r.right < r.left) {
            f = r.right;
            r.right = r.left;
            r.left = f;
        }
        if (r.bottom < r.top) {
            f = r.top;
            r.top = r.bottom;
            r.bottom = f;
        }
    }

    private void transformMatrix(Matrix m, View view) {
        float w = view.getWidth();
        float h = view.getHeight();
        float sX = this.mScaleX;
        float sY = this.mScaleY;
        if (sX != 1.0f || sY != 1.0f) {
            float deltaSX = (sX * w - w) / 2.0f;
            float deltaSY = (sY * h - h) / 2.0f;
            m.postScale(sX, sY);
            m.postTranslate(-deltaSX, -deltaSY);
        }
        m.postTranslate(this.mTranslationX, this.mTranslationY);
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        View view = (View)this.mView.get();
        if (view != null) {
            t.setAlpha(this.mAlpha);
            this.transformMatrix(t.getMatrix(), view);
        }
    }

    public void reset() {
    }
}

